/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dnd.attachment.providers;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.issue.attachment.AttachmentService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.plugin.webfragment.contextproviders.AbstractJiraContextProvider;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import webwork.config.Configuration;

public class MetadataContextProvider
extends AbstractJiraContextProvider {
    private final AttachmentService attachmentService;

    public MetadataContextProvider(AttachmentService attachmentService) {
        this.attachmentService = attachmentService;
    }

    public Map getContextMap(ApplicationUser applicationUser, JiraHelper jiraHelper) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Project project = jiraHelper.getProject();
        builder.put((Object)"canAttach", (Object)Optional.ofNullable(this.canAttach(applicationUser, project)).orElse(false).toString());
        if (project != null && project.getProjectTypeKey() != null) {
            builder.put((Object)"projectType", (Object)project.getProjectTypeKey().getKey());
        } else {
            builder.put((Object)"projectType", (Object)"");
        }
        builder.put((Object)"uploadLimit", (Object)Configuration.getString((String)"webwork.multipart.maxSize"));
        builder.put((Object)"thumbnailsAllowed", (Object)ComponentAccessor.getApplicationProperties().getOption("jira.option.allowthumbnails"));
        return builder.build();
    }

    private Boolean canAttach(ApplicationUser applicationUser, Project project) {
        JiraServiceContextImpl context = new JiraServiceContextImpl(applicationUser, (ErrorCollection)new SimpleErrorCollection());
        return this.attachmentService.canCreateAttachments((JiraServiceContext)context, project);
    }
}

