/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dnd.attachment.rest;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.issue.attachment.AttachmentService;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.issue.AttachmentError;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.AttachmentsBulkOperationResult;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.attachment.TemporaryWebAttachmentManager;
import com.atlassian.jira.issue.fields.rest.IssueFinder;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.dto.AttachmentViewDtoConverter;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.util.IssueUpdateBean;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.plugins.rest.common.security.RequiresXsrfCheck;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

@Path(value="attachment")
@AnonymousAllowed
@Produces(value={"application/json"})
public class AttachmentResource {
    private final AttachmentService attachmentService;
    private final JiraAuthenticationContext authContext;
    private final IssueFinder issueFinder;
    private final I18nHelper i18nHelper;
    private final AttachmentManager attachmentManager;
    private final TemporaryWebAttachmentManager temporaryAttachmentManager;
    private final IssueUpdater issueUpdater;
    private final AttachmentViewDtoConverter attachmentConverter;

    public AttachmentResource(AttachmentService attachmentService, JiraAuthenticationContext authContext, IssueFinder issueFinder, I18nHelper i18nHelper, AttachmentManager attachmentManager, TemporaryWebAttachmentManager temporaryAttachmentManager, IssueUpdater issueUpdater, JiraBaseUrls jiraBaseUrls, VelocityRequestContextFactory velocityRequestContextFactory, AttachmentViewDtoConverter attachmentConverter) {
        this.attachmentService = attachmentService;
        this.authContext = authContext;
        this.issueFinder = issueFinder;
        this.i18nHelper = i18nHelper;
        this.attachmentManager = attachmentManager;
        this.temporaryAttachmentManager = temporaryAttachmentManager;
        this.issueUpdater = issueUpdater;
        this.attachmentConverter = attachmentConverter;
    }

    @POST
    @RequiresXsrfCheck
    public Response attachTemporaryfile(@FormParam(value="id") String id, @FormParam(value="formToken") String formToken, @FormParam(value="filetoconvert") List<String> fileIdsToConvert) {
        MutableIssue issue;
        JiraServiceContextImpl context = new JiraServiceContextImpl(this.authContext.getLoggedInUser());
        if (!this.attachmentService.canCreateAttachments((JiraServiceContext)context, (Issue)(issue = this.getIssueObject(id)))) {
            throw new RESTException(Response.Status.FORBIDDEN, ErrorCollection.of((String[])new String[]{this.i18nHelper.getText("attachment.service.error.create.no.permission")}));
        }
        AttachmentsBulkOperationResult convertResult = this.temporaryAttachmentManager.convertTemporaryAttachments(this.authContext.getUser(), (Issue)issue, fileIdsToConvert);
        if (!convertResult.getErrors().isEmpty()) {
            SimpleErrorCollection errors = new SimpleErrorCollection();
            for (AttachmentError error : convertResult.getErrors()) {
                errors.addError(error.getFilename(), error.getLocalizedMessage(), error.getReason());
            }
            throw new RESTException(Response.Status.INTERNAL_SERVER_ERROR, ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)errors));
        }
        List changeItemBeans = convertResult.getResults();
        IssueUpdateBean issueUpdateBean = new IssueUpdateBean((Issue)issue, (Issue)issue, EventType.ISSUE_UPDATED_ID, this.authContext.getLoggedInUser());
        issueUpdateBean.setChangeItems((Collection)changeItemBeans);
        issueUpdateBean.setDispatchEvent(true);
        issueUpdateBean.setParams((Map)ImmutableMap.of((Object)"eventsource", (Object)"action"));
        this.issueUpdater.doUpdate(issueUpdateBean, true);
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        for (ChangeItemBean changeItemBean : changeItemBeans) {
            Attachment attachment;
            String idStringValue = changeItemBean.getTo();
            if (idStringValue == null || (attachment = this.attachmentManager.getAttachment(Long.valueOf(idStringValue))) == null) continue;
            attachments.add(attachment);
        }
        Collection jsonDtos = this.attachmentConverter.convert(attachments);
        return Response.ok((Object)jsonDtos).cacheControl(CacheControl.never()).build();
    }

    private MutableIssue getIssueObject(String issueIdOrKey) throws WebApplicationException {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        MutableIssue issue = (MutableIssue)this.issueFinder.findIssue(issueIdOrKey, (com.atlassian.jira.util.ErrorCollection)errors);
        if (issue == null) {
            throw new RESTException(Response.Status.NOT_FOUND, errors);
        }
        return issue;
    }

    static class RESTException
    extends WebApplicationException {
        RESTException(Response.Status status, SimpleErrorCollection errors) {
            super(Response.status((Response.Status)status).entity((Object)ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)errors)).cacheControl(CacheControl.never()).build());
        }

        RESTException(Response.Status status, ErrorCollection errors) {
            super(Response.status((Response.Status)status).entity((Object)errors).cacheControl(CacheControl.never()).build());
        }
    }
}

