/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pocketknife.api.rest;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.pocketknife.api.rest.RestCall;
import com.atlassian.pocketknife.api.rest.RestErrorResponse;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;

public class AbstractRestResource {
    protected final Logger log;
    protected final JiraAuthenticationContext jiraAuthenticationContext;

    protected AbstractRestResource(Class className, JiraAuthenticationContext jiraAuthenticationContext) {
        this.log = Logger.getLogger((Class)className);
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    protected Response response(Callable<Response> responseCallable) {
        return new RestCall(this.log).response(responseCallable);
    }

    protected boolean isAnonymousUser() {
        return this.getUser() == null;
    }

    protected ApplicationUser getUser() {
        return this.jiraAuthenticationContext.getUser();
    }

    protected User getLoggedInUser() {
        return this.jiraAuthenticationContext.getLoggedInUser();
    }

    protected String getText(String key, Object ... params) {
        return this.jiraAuthenticationContext.getI18nHelper().getText(key, (Object)params);
    }

    protected Response noContent() {
        return Response.noContent().build();
    }

    protected Response ok(Object result) {
        return Response.ok((Object)result).cacheControl(this.never()).build();
    }

    protected Response created(Object result) {
        return Response.status((Response.Status)Response.Status.CREATED).entity(result).cacheControl(this.never()).build();
    }

    protected Response notModified() {
        return Response.notModified().build();
    }

    protected Response errorResponse(String reasonKey, ErrorCollection errors) {
        Response.Status status = this.getMostAppropriateStatus(errors);
        return this.createErrorResponse(status, reasonKey, errors);
    }

    private Response.Status getMostAppropriateStatus(ErrorCollection errors) {
        if (errors.getReasons().isEmpty()) {
            return Response.Status.INTERNAL_SERVER_ERROR;
        }
        int statusCode = ((ErrorCollection.Reason)errors.getReasons().iterator().next()).getHttpStatusCode();
        return Response.Status.fromStatusCode((int)statusCode);
    }

    protected Response notFoundRequest(String reasonKey) {
        return this.createErrorResponse(Response.Status.NOT_FOUND, reasonKey);
    }

    protected Response notFoundRequest(String reasonKey, String errorMessage) {
        return this.createErrorResponse(Response.Status.NOT_FOUND, reasonKey, errorMessage);
    }

    protected Response notFoundRequest(String reasonKey, String errorMessage, String field) {
        return this.createErrorResponseForField(Response.Status.NOT_FOUND, reasonKey, errorMessage, field);
    }

    protected Response notFoundRequest(String reasonKey, ErrorCollection errorCollection) {
        return this.createErrorResponse(Response.Status.NOT_FOUND, reasonKey, errorCollection);
    }

    protected Response forbiddenRequest(String reasonKey) {
        return this.createErrorResponse(Response.Status.FORBIDDEN, reasonKey);
    }

    protected Response forbiddenRequest(String reasonKey, String errorMessage) {
        return this.createErrorResponse(Response.Status.FORBIDDEN, reasonKey, errorMessage);
    }

    protected Response forbiddenRequest(String reasonKey, String errorMessage, String field) {
        return this.createErrorResponseForField(Response.Status.FORBIDDEN, reasonKey, errorMessage, field);
    }

    protected Response forbiddenRequest(String reasonKey, ErrorCollection errorCollection) {
        return this.createErrorResponse(Response.Status.FORBIDDEN, reasonKey, errorCollection);
    }

    protected Response unauthorizedRequest(String reasonKey) {
        return this.createErrorResponse(Response.Status.UNAUTHORIZED, reasonKey);
    }

    protected Response unauthorizedRequest(String reasonKey, String errorMessage) {
        return this.createErrorResponse(Response.Status.UNAUTHORIZED, reasonKey, errorMessage);
    }

    protected Response unauthorizedRequest(String reasonKey, String errorMessage, String field) {
        return this.createErrorResponseForField(Response.Status.UNAUTHORIZED, reasonKey, errorMessage, field);
    }

    protected Response unauthorizedRequest(String reasonKey, ErrorCollection errorCollection) {
        return this.createErrorResponse(Response.Status.UNAUTHORIZED, reasonKey, errorCollection);
    }

    protected Response badRequest(String reasonKey) {
        return this.createErrorResponse(Response.Status.BAD_REQUEST, reasonKey);
    }

    protected Response badRequest(String reasonKey, String errorMessage) {
        return this.createErrorResponse(Response.Status.BAD_REQUEST, reasonKey, errorMessage);
    }

    protected Response badRequest(String reasonKey, String errorMessage, String field) {
        return this.createErrorResponseForField(Response.Status.BAD_REQUEST, reasonKey, errorMessage, field);
    }

    protected Response badRequest(String reasonKey, ErrorCollection errorCollection) {
        return this.createErrorResponse(Response.Status.BAD_REQUEST, reasonKey, errorCollection);
    }

    private CacheControl never() {
        CacheControl cacheNever = new CacheControl();
        cacheNever.setNoStore(true);
        cacheNever.setNoCache(true);
        return cacheNever;
    }

    private Response createErrorResponse(Response.Status status, String reasonKey) {
        RestErrorResponse error = new RestErrorResponse(reasonKey, String.valueOf(status.getStatusCode()));
        return Response.status((Response.Status)status).entity((Object)error).build();
    }

    private Response createErrorResponse(Response.Status status, String reasonKey, String errorMessage) {
        RestErrorResponse error = new RestErrorResponse(reasonKey, String.valueOf(status.getStatusCode()));
        error.addError(errorMessage);
        return Response.status((Response.Status)status).entity((Object)error).build();
    }

    private Response createErrorResponseForField(Response.Status status, String reasonKey, String errorMessage, String field) {
        RestErrorResponse error = new RestErrorResponse(reasonKey, String.valueOf(status.getStatusCode()));
        error.addError(errorMessage, field);
        return Response.status((Response.Status)status).entity((Object)error).build();
    }

    private Response createErrorResponse(Response.Status status, String reasonKey, ErrorCollection errorCollection) {
        RestErrorResponse error = new RestErrorResponse(reasonKey, String.valueOf(status.getStatusCode()));
        for (String string : errorCollection.getErrorMessages()) {
            error.addError(string);
        }
        for (Map.Entry entry : errorCollection.getErrors().entrySet()) {
            error.addError((String)entry.getValue(), (String)entry.getKey());
        }
        return Response.status((Response.Status)status).entity((Object)error).build();
    }
}

