/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client;

import com.atlassian.jira.testkit.client.BackdoorControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.ws.rs.client.Entity;

public class ApplicationPropertiesControl
extends BackdoorControl<ApplicationPropertiesControl> {
    public ApplicationPropertiesControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public ApplicationPropertiesControl setOption(String key, boolean value) {
        this.get(this.createResource().path("applicationProperties/option/set").queryParam("key", new Object[]{key}).queryParam("value", new Object[]{"" + value}));
        return this;
    }

    public ApplicationPropertiesControl setText(String key, String value) {
        this.createResource().path("applicationProperties/text/set").request().post(Entity.json((Object)new KeyValueHolder(key, value)), String.class);
        return this;
    }

    public ApplicationPropertiesControl setString(String key, String value) {
        this.createResource().path("applicationProperties/string/set").request().post(Entity.json((Object)new KeyValueHolder(key, value)), String.class);
        return this;
    }

    public boolean getOption(String key) {
        return Boolean.valueOf(this.get(this.createResource().path("applicationProperties/option/get").queryParam("key", new Object[]{key})));
    }

    public String getString(String key) {
        return this.get(this.createResource().path("applicationProperties/string/get").queryParam("key", new Object[]{key}));
    }

    public ApplicationPropertiesControl disableXsrfChecking() {
        return this.setOption("jira.xsrf.enabled", false);
    }

    public ApplicationPropertiesControl enableXsrfChecking() {
        return this.setOption("jira.xsrf.enabled", true);
    }

    public String getJiraHome() {
        ConfigInfo info = (ConfigInfo)this.createResource().path("config-info").request().get(ConfigInfo.class);
        return info.jiraHomePath;
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ConfigInfo {
        public String jiraHomePath;
        public boolean isSetUp;

        public ConfigInfo() {
        }

        public ConfigInfo(String home, boolean isSetUp) {
            this.jiraHomePath = home;
            this.isSetUp = isSetUp;
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class KeyValueHolder {
        public String key;
        public String value;

        public KeyValueHolder(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

