/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.testkit.client.log.FuncTestLoggerImpl;
import javax.ws.rs.client.WebTarget;

public abstract class BackdoorControl<T extends BackdoorControl<T>>
extends RestApiClient<T> {
    public static final String DEFAULT_REST_PATH = "testkit-test";
    public static final String API_REST_PATH = "api";
    public static final String API_REST_VERSION = "2";
    protected final String rootPath;
    protected final FuncTestLogger logger;

    public BackdoorControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
        this.rootPath = environmentData.getBaseUrl().toExternalForm();
        this.logger = new FuncTestLoggerImpl(2);
    }

    protected final String get(WebTarget webTarget) {
        return (String)webTarget.request().get(String.class);
    }

    protected final WebTarget createResourceForPath(String restModulePath) {
        return this.createResourceForPath(restModulePath, "1.0");
    }

    protected final WebTarget createResourceForPath(String restModulePath, String restModuleVersion) {
        return this.resourceRoot(this.rootPath).path("rest").path(restModulePath).path(restModuleVersion);
    }

    @Override
    protected WebTarget createResource() {
        return this.createResourceForPath(this.getRestModulePath());
    }

    protected String getRestModulePath() {
        return DEFAULT_REST_PATH;
    }
}

