/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;

public class CurrentUserPreferencesClient
extends RestApiClient<CurrentUserPreferencesClient> {
    private static final String PREFERENCES_PATH = "mypreferences";
    private static final String KEY = "key";
    private Set<Response> responses = Sets.newHashSet();

    public CurrentUserPreferencesClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public Response getPreference(String key) {
        WebTarget webTarget = this.createResource().path(PREFERENCES_PATH);
        if (key != null) {
            webTarget = webTarget.queryParam(KEY, new Object[]{key});
        }
        Response clientResponse = (Response)webTarget.request().get(Response.class);
        this.responses.add(clientResponse);
        return clientResponse;
    }

    public Response setPreference(String key, String value) {
        WebTarget webTarget = this.createResource().path(PREFERENCES_PATH);
        if (key != null) {
            webTarget = webTarget.queryParam(KEY, new Object[]{key});
        }
        Response put = (Response)webTarget.request(new String[]{"application/json"}).put(Entity.json((Object)value), Response.class);
        this.responses.add(put);
        return put;
    }

    public Response removePreference(String key) {
        WebTarget webTarget = this.createResource().path(PREFERENCES_PATH);
        if (key != null) {
            webTarget = webTarget.queryParam(KEY, new Object[]{key});
        }
        Response delete = (Response)webTarget.request().delete(Response.class);
        this.responses.add(delete);
        return delete;
    }

    public void close() {
        for (Response response : this.responses) {
            response.close();
        }
    }
}

