/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client;

import com.atlassian.jira.testkit.beans.CustomFieldDefaultValue;
import com.atlassian.jira.testkit.beans.CustomFieldRequest;
import com.atlassian.jira.testkit.beans.CustomFieldResponse;
import com.atlassian.jira.testkit.beans.UserFilter;
import com.atlassian.jira.testkit.client.BackdoorControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;

public class CustomFieldsControl
extends BackdoorControl<CustomFieldsControl> {
    public CustomFieldsControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public String createCustomField(String name, String description, String type, String searcherKey) {
        CustomFieldRequest request = new CustomFieldRequest();
        request.name = name;
        request.description = description;
        request.type = type;
        request.searcherKey = searcherKey;
        CustomFieldResponse response = (CustomFieldResponse)this.createResource().path("customFields/create").request().post(Entity.json((Object)request), CustomFieldResponse.class);
        return response.id;
    }

    public String createCustomField(String name, String description, String type, String searcherKey, boolean enabled, Set<Long> roleIds, Set<String> groups) {
        UserFilter userFilter;
        CustomFieldRequest request = new CustomFieldRequest();
        request.name = name;
        request.description = description;
        request.type = type;
        request.searcherKey = searcherKey;
        request.userFilter = userFilter = new UserFilter(enabled, groups, roleIds);
        CustomFieldResponse response = (CustomFieldResponse)this.createResource().path("customFields/create").request().post(Entity.json((Object)request), CustomFieldResponse.class);
        return response.id;
    }

    public void updateCustomField(String id, String name, String description, String searcherKey) {
        CustomFieldRequest request = new CustomFieldRequest();
        request.name = name;
        request.description = description;
        request.searcherKey = searcherKey;
        this.createResource().path("customFields").path(id).request().put(Entity.json((Object)request));
    }

    public void deleteCustomField(String customFieldId) {
        this.createResource().path("customFields").path("delete").path(customFieldId).request().delete();
    }

    public void addOption(String customFieldId, String optionValue) {
        this.addOption(customFieldId, optionValue, null);
    }

    public void addOption(String customFieldId, String optionValue, @Nullable Long configSchemeId) {
        WebTarget r = this.createResource().path("customFields/addOption").path(customFieldId);
        if (configSchemeId != null) {
            r = r.queryParam("contextId", new Object[]{String.valueOf(configSchemeId)});
        }
        r.request().post(Entity.json((Object)optionValue));
    }

    public void addChildOption(String customFieldId, String parentOptionId, String optionValue) {
        this.addChildOption(customFieldId, parentOptionId, optionValue, null);
    }

    public void addChildOption(String customFieldId, String parentOptionId, String optionValue, @Nullable Long configSchemeId) {
        WebTarget r = this.createResource().path("customFields/addChildOption").path(customFieldId).path(parentOptionId);
        if (configSchemeId != null) {
            r = r.queryParam("contextId", new Object[]{String.valueOf(configSchemeId)});
        }
        r.request().post(Entity.json((Object)optionValue));
    }

    public void enableOption(Long customFieldOptionId) {
        this.createResource().path("customFields/enableOption").path(customFieldOptionId.toString()).request().put(null);
    }

    public void disableOption(Long customFieldOptionId) {
        this.createResource().path("customFields/disableOption").path(customFieldOptionId.toString()).request().put(null);
    }

    public void deleteOption(String customFieldId, String optionValue) {
        this.deleteOption(customFieldId, optionValue, null);
    }

    public void deleteOption(String customFieldId, String optionValue, @Nullable Long configSchemeId) {
        WebTarget r = this.createResource().path("customFields/deleteOption").path(customFieldId);
        if (configSchemeId != null) {
            r = r.queryParam("contextId", new Object[]{String.valueOf(configSchemeId)});
        }
        r.request().method("DELETE", Entity.json((Object)optionValue));
    }

    public List<CustomFieldResponse> getCustomFields() {
        return this.getCustomFields(false);
    }

    public List<CustomFieldResponse> getCustomFields(boolean config) {
        return (List)this.createResource().path("customFields").path("get").queryParam("config", new Object[]{String.valueOf(config)}).request().get((GenericType)new GenericType<List<CustomFieldResponse>>(){});
    }

    public CustomFieldResponse getCustomField(String id) {
        return this.getCustomField(id, false);
    }

    public CustomFieldResponse getCustomField(String id, boolean config) {
        return (CustomFieldResponse)this.createResource().path("customFields").path(id).queryParam("config", new Object[]{String.valueOf(config)}).request().get((GenericType)new GenericType<CustomFieldResponse>(){});
    }

    public long createCustomFieldContext(String customFieldId, List<Long> projectIds, List<Long> issueTypeIds) {
        WebTarget r = this.createResource().path("customFields").path("addCustomFieldContext").queryParam("customFieldId", new Object[]{String.valueOf(customFieldId)});
        for (Long projectId : projectIds) {
            r = r.queryParam("projectIds", new Object[]{String.valueOf(projectId)});
        }
        for (Long id : issueTypeIds) {
            r = r.queryParam("issueTypeIds", new Object[]{String.valueOf(id)});
        }
        return (Long)r.request().post(Entity.json(null), Long.class);
    }

    public void deleteCustomFieldContext(String contextId) {
        WebTarget r = this.createResource().path("customFields").path("deleteCustomFieldContext").queryParam("contextId", new Object[]{String.valueOf(contextId)});
        r.request().delete(Response.class);
    }

    public void setDefaultValueForContext(Long contextId, Object value) {
        CustomFieldDefaultValue request = new CustomFieldDefaultValue();
        request.value = value == null ? null : value.toString();
        this.createResource().path("customFields").path("defaultValueForContext").path(contextId.toString()).request().put(Entity.json((Object)request));
    }

    public String getDefaultValueForContext(Long contextId) {
        return (String)this.createResource().path("customFields").path("defaultValueForContext").path(contextId.toString()).request().get(String.class);
    }
}

