/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client;

import com.atlassian.gadgets.dashboard.Layout;
import com.atlassian.jira.testkit.client.BackdoorControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class DashboardControl
extends BackdoorControl<DashboardControl> {
    private static final GenericType<List<Dashboard>> DASHBOARD_LIST_GENERIC_TYPE = new GenericType<List<Dashboard>>(){};
    private static final GenericType<Dashboard> DASHBOARD_GENERIC_TYPE = new GenericType<Dashboard>(){};

    public DashboardControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public Optional<Dashboard> getDashboard(long id) {
        return this.getDashboard(id, null);
    }

    public Optional<Dashboard> getDashboard(long id, @Nullable String username) {
        try {
            WebTarget resource = this.createResource().path("dashboard").path(Long.toString(id));
            if (username != null) {
                resource.queryParam("username", new Object[]{username});
            }
            return Optional.of(resource.request().get(DASHBOARD_GENERIC_TYPE));
        }
        catch (WebApplicationException ex) {
            if (ex.getResponse() != null && Response.Status.NOT_FOUND.getStatusCode() == ex.getResponse().getStatus()) {
                return Optional.empty();
            }
            throw ex;
        }
    }

    public List<Dashboard> getOwnedDashboard(String username) {
        return (List)this.createResource().path("dashboard").path("my").queryParam("username", new Object[]{username}).request().get(DASHBOARD_LIST_GENERIC_TYPE);
    }

    public DashboardControl emptySystemDashboard() {
        this.createResource().path("dashboard").path("emptySystemDashboard").request().get(String.class);
        return this;
    }

    public Dashboard createDashboard(String username, String name, String description, Layout layout, boolean global, boolean favorite) {
        WebTarget resource = this.createResource().path("dashboard").path("add").queryParam("username", new Object[]{username}).queryParam("name", new Object[]{name}).queryParam("global", new Object[]{global ? "true" : "false"}).queryParam("favorite", new Object[]{favorite ? "true" : "false"});
        if (description != null) {
            resource = resource.queryParam("description", new Object[]{description});
        }
        if (layout != null) {
            resource = resource.queryParam("layout", new Object[]{layout.name()});
        }
        return (Dashboard)resource.request().get(Dashboard.class);
    }

    public void deleteDashboard(String username, Long id) {
        WebTarget resource = this.createResource().path("dashboard").path("delete").queryParam("username", new Object[]{username}).queryParam("id", new Object[]{Long.toString(id)});
        resource.request().get(String.class);
    }

    public Dashboard updateDashboard(String username, Long id, String name, String ownername, String description, String shareGroupName, boolean favorite) {
        WebTarget resource = this.createResource().path("dashboard").path("update").queryParam("username", new Object[]{username}).queryParam("id", new Object[]{Long.toString(id)}).queryParam("ownername", new Object[]{ownername}).queryParam("favorite", new Object[]{favorite ? "true" : "false"});
        if (description != null) {
            resource = resource.queryParam("description", new Object[]{description});
        }
        if (name != null) {
            resource = resource.queryParam("name", new Object[]{name});
        }
        if (shareGroupName != null) {
            resource = resource.queryParam("shareGroupName", new Object[]{shareGroupName});
        }
        return (Dashboard)resource.request().get(Dashboard.class);
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Dashboard {
        private long id;
        private String name;
        private String owner;
        private String description;
        private long favouriteCount;
        private boolean favourite;

        public Long getId() {
            return this.id;
        }

        public Dashboard setId(Long id) {
            this.id = id;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Dashboard setName(String name) {
            this.name = name;
            return this;
        }

        public String getOwner() {
            return this.owner;
        }

        public Dashboard setOwner(String owner) {
            this.owner = owner;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public Dashboard setDescription(String description) {
            this.description = description;
            return this;
        }

        public long getFavouriteCount() {
            return this.favouriteCount;
        }

        public Dashboard setFavouriteCount(long favouriteCount) {
            this.favouriteCount = favouriteCount;
            return this;
        }

        public boolean isFavourite() {
            return this.favourite;
        }

        public Dashboard setFavourite(boolean favourite) {
            this.favourite = favourite;
            return this;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

