/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client;

import com.atlassian.jira.testkit.client.BackdoorControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestoreDataResources;
import com.atlassian.jira.testkit.client.dump.FuncTestTimer;
import com.atlassian.jira.testkit.client.dump.TestInformationKit;
import com.atlassian.jira.testkit.client.xmlbackup.XmlBackupCopier;
import com.atlassian.jira.testkit.util.ClasspathResources;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataImportControl
extends BackdoorControl<DataImportControl> {
    private static final Logger log = LoggerFactory.getLogger(DataImportControl.class);
    public static final String FS = System.getProperty("file.separator");
    public static final String IMPORT = "import";
    public static final String TESTKIT_XML_PACKAGE = "testkit/xmlresources";
    public static final String TESTKIT_BLANKPROJECTS = "testkit-blankprojects-";
    public static final String TESTKIT_BLANKPROJECTS_XML = "testkit/xmlresources/testkit-blankprojects-";
    public static final Pattern TESTKIT_BLANKPROJECTS_XML_PATTERN = Pattern.compile(".*testkit-blankprojects-(\\d+)\\.xml");
    private static final long STARTUP_TIMEOUT_NANOS = TimeUnit.MINUTES.toNanos(3L);
    private static final long STARTUP_POLL_INTERVAL_MILLIS = 1000L;
    private static final String RETRY_AFTER = "Retry-After";
    private static final List<Integer> REST_NOT_SETUP_ERROR_CODES = ImmutableList.of((Object)Response.Status.NOT_FOUND.getStatusCode(), (Object)Response.Status.SERVICE_UNAVAILABLE.getStatusCode());
    private static final ThreadLocal<ImportConfig> JIRA_CONFIG = new ThreadLocal();
    private static final ThreadLocal<List<Integer>> SUPPORTED_BUILD_NUMBERS = new ThreadLocal<List<Integer>>(){

        @Override
        protected List<Integer> initialValue() {
            Iterable matchingResources = ClasspathResources.getResources((String)DataImportControl.TESTKIT_XML_PACKAGE, (Pattern)TESTKIT_BLANKPROJECTS_XML_PATTERN);
            return Ordering.natural().sortedCopy(Iterables.transform((Iterable)matchingResources, this.toSupportedBuildNumber()));
        }

        private Function<String, Integer> toSupportedBuildNumber() {
            return new Function<String, Integer>(){

                public Integer apply(String name) {
                    Matcher matcher = TESTKIT_BLANKPROJECTS_XML_PATTERN.matcher(name);
                    if (matcher.matches()) {
                        return Integer.parseInt(matcher.group(1));
                    }
                    throw new IllegalStateException("Unexpected blank XML resource name: " + name);
                }
            };
        }
    };
    private JIRAEnvironmentData environmentData;
    private XmlBackupCopier xmlBackupCopier;

    public DataImportControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
        this.environmentData = environmentData;
        this.xmlBackupCopier = new XmlBackupCopier(environmentData.getBaseUrl());
    }

    public boolean isSetUp() {
        try {
            WebTarget serverInfo = this.resourceRoot(this.environmentData.getBaseUrl().toExternalForm()).path("rest").path("api").path("2").path("serverInfo");
            DataImportControl.getWithStartupRetry(serverInfo, String.class);
            return true;
        }
        catch (WebApplicationException interfaceException) {
            if (DataImportControl.looksLikeNotSetup(interfaceException)) {
                return false;
            }
            throw new IllegalStateException("Unknown error when trying to check JIRA setup status", interfaceException);
        }
    }

    private static <T> T getWithStartupRetry(WebTarget resource, Class<T> tClass) throws WebApplicationException {
        long deadline = System.nanoTime() + STARTUP_TIMEOUT_NANOS;
        WebApplicationException lastEx = null;
        while (true) {
            try {
                return (T)resource.request().get(tClass);
            }
            catch (WebApplicationException uie) {
                if (!DataImportControl.looksLikeStillStartingUp(uie)) {
                    throw uie;
                }
                lastEx = uie;
                DataImportControl.startupPhaseStall();
                if (System.nanoTime() < deadline) continue;
                throw new IllegalStateException("Timed out while waiting for JIRA startup to complete", lastEx);
            }
            break;
        }
    }

    private static void startupPhaseStall() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ie) {
            throw new RuntimeException("Interrupted while waiting for JIRA startup to complete", ie);
        }
    }

    private static boolean looksLikeStillStartingUp(WebApplicationException ex) {
        Response response = ex.getResponse();
        return response.getStatus() == Response.Status.SERVICE_UNAVAILABLE.getStatusCode() && response.getHeaders().containsKey((Object)RETRY_AFTER);
    }

    private static boolean looksLikeNotSetup(WebApplicationException interfaceException) {
        return REST_NOT_SETUP_ERROR_CODES.contains(interfaceException.getResponse().getStatus());
    }

    public void restoreBlankInstance() {
        this.restoreBlankInstance("AAACeg0ODAoPeNp1VNFymkAUfecrdqYvbWYwgG2TOMODAommEQxiTFP7sC4X2QR3ye6itV/fFWUin\neTR473n3nPOXT4lFaCIKGRbyLrqWRe9bhfdjBPkWE7XmILYgBj57uDmKjEfZw9fzR9PT0NzYNlz4\n44SYBKSXQkhXoM7TfpxEsQGEXybdk7+db09sughHzZQ8BKEQTjLOpgougFXiQp0U0XosoAWeOQI/\npRU7HyswJ3YjjV8K24POYCtOc9U4BZlWK2XIKJsJkFI17YMHyQRtFSUMzcBqVBx4EQZF6gsqhVlK\nG34JPp8qxmR730xjnUPGt33OkawwUWFa6IMFxKMMaZMAcOMvCNhb0BrfQ0UFejalgBPQE1Ztzq27\nZiWYzrfDv2NGK+opAIR8hSkaxlnZ2deHPSTwDcHP/UPF68Yxelf+mKQgutAW468wK7RYH+3rAvrs\ntu1jSVeLzlvbTioIRRoTaIUVLYXbTcEKa2NCEJ9EZN4NA2a0S3NNdTWy5nS2wXau+J07/qmTteuk\n/142jGdIZa5O/a23vXN/D57SC4ZDL7N2bb0B+vu3XBqpZi+9vP7BOeZHVnYJrfh62x794hhXJC5Y\nz/2F+7CNTIqc9i1r1M7G0aJeR3F5iSO/JmXjKLQnE2DveV1bpCi5Q6pHNBxUW0e0SHpwxL8GfSr+\n5UrVS565+cr3sGqwFJSzDqEr8+PAkw4dPzuIJ8jxhVKqVSCLisFmplKpDgiOn6+1iF2jEisMKPyc\nIb9hrF5Sfolz9gL41vW5HUqaFIJkmMJ/9/aqdV1brejuP/RHdTFmgF7sC84MDf2nZJcayzYwXvp1\n5+Tt/D/AWRvnywwLAIUEZXThN7ewKC0ZpUJNMb0AjCOFOoCFEc6FJjjyL/r53YmAwBO/uYEuSROX\n02td");
    }

    public void restoreBlankInstance(String license) {
        String resource = this.findMatchingResource(this.getImportConfig().buildNumber);
        log.info("Restoring blank resource {}", (Object)resource);
        this.restoreDataFromResource(resource, license);
    }

    public void restoreBlankInstance(String license, BiConsumer<String, String> copyFunction) {
        String resource = this.findMatchingResource(this.getImportConfig().buildNumber);
        log.info("Restoring blank resource {}", (Object)resource);
        this.restoreDataFromResource(resource, license, copyFunction);
    }

    @VisibleForTesting
    protected String findMatchingResource(int buildNumber) {
        int index = Ordering.natural().binarySearch(SUPPORTED_BUILD_NUMBERS.get(), (Object)buildNumber);
        if (index >= 0) {
            return this.blankResourceForBuildNumber(index);
        }
        if (index == -1) {
            throw new IllegalStateException("The build number " + buildNumber + " is not supported");
        }
        return this.blankResourceForBuildNumber(-index - 2);
    }

    private String blankResourceForBuildNumber(int index) {
        return TESTKIT_BLANKPROJECTS_XML + SUPPORTED_BUILD_NUMBERS.get().get(index) + ".xml";
    }

    @Deprecated
    public void restoreData(String xmlFileName) {
        this.restoreData(xmlFileName, "AAACeg0ODAoPeNp1VNFymkAUfecrdqYvbWYwgG2TOMODAommEQxiTFP7sC4X2QR3ye6itV/fFWUin\neTR473n3nPOXT4lFaCIKGRbyLrqWRe9bhfdjBPkWE7XmILYgBj57uDmKjEfZw9fzR9PT0NzYNlz4\n44SYBKSXQkhXoM7TfpxEsQGEXybdk7+db09sughHzZQ8BKEQTjLOpgougFXiQp0U0XosoAWeOQI/\npRU7HyswJ3YjjV8K24POYCtOc9U4BZlWK2XIKJsJkFI17YMHyQRtFSUMzcBqVBx4EQZF6gsqhVlK\nG34JPp8qxmR730xjnUPGt33OkawwUWFa6IMFxKMMaZMAcOMvCNhb0BrfQ0UFejalgBPQE1Ztzq27\nZiWYzrfDv2NGK+opAIR8hSkaxlnZ2deHPSTwDcHP/UPF68Yxelf+mKQgutAW468wK7RYH+3rAvrs\ntu1jSVeLzlvbTioIRRoTaIUVLYXbTcEKa2NCEJ9EZN4NA2a0S3NNdTWy5nS2wXau+J07/qmTteuk\n/142jGdIZa5O/a23vXN/D57SC4ZDL7N2bb0B+vu3XBqpZi+9vP7BOeZHVnYJrfh62x794hhXJC5Y\nz/2F+7CNTIqc9i1r1M7G0aJeR3F5iSO/JmXjKLQnE2DveV1bpCi5Q6pHNBxUW0e0SHpwxL8GfSr+\n5UrVS565+cr3sGqwFJSzDqEr8+PAkw4dPzuIJ8jxhVKqVSCLisFmplKpDgiOn6+1iF2jEisMKPyc\nIb9hrF5Sfolz9gL41vW5HUqaFIJkmMJ/9/aqdV1brejuP/RHdTFmgF7sC84MDf2nZJcayzYwXvp1\n5+Tt/D/AWRvnywwLAIUEZXThN7ewKC0ZpUJNMb0AjCOFOoCFEc6FJjjyL/r53YmAwBO/uYEuSROX\n02td");
    }

    @Deprecated
    public void restoreData(String xmlFileName, String license) {
        FuncTestTimer timer = TestInformationKit.pullTimer("XML Restore");
        String sourcePath = this.environmentData.getXMLDataLocation().getAbsolutePath() + FS + xmlFileName;
        String jiraImportPath = this.getJiraHomePath() + FS + IMPORT + FS + new File(xmlFileName).getName();
        boolean baseUrlReplaced = this.xmlBackupCopier.copyXmlBackupTo(sourcePath, jiraImportPath);
        DataImportBean importBean = new DataImportBean();
        importBean.filePath = jiraImportPath;
        importBean.licenseString = license;
        importBean.useDefaultPaths = false;
        importBean.quickImport = true;
        importBean.isSetup = false;
        if (baseUrlReplaced) {
            importBean.baseUrl = this.environmentData.getBaseUrl().toString();
        }
        this.createResource().path("dataImport").request().post(Entity.json((Object)importBean), String.class);
        timer.end();
    }

    public void restoreDataFromResource(String resourcePath) {
        this.restoreDataFromResource(resourcePath, "AAACeg0ODAoPeNp1VNFymkAUfecrdqYvbWYwgG2TOMODAommEQxiTFP7sC4X2QR3ye6itV/fFWUin\neTR473n3nPOXT4lFaCIKGRbyLrqWRe9bhfdjBPkWE7XmILYgBj57uDmKjEfZw9fzR9PT0NzYNlz4\n44SYBKSXQkhXoM7TfpxEsQGEXybdk7+db09sughHzZQ8BKEQTjLOpgougFXiQp0U0XosoAWeOQI/\npRU7HyswJ3YjjV8K24POYCtOc9U4BZlWK2XIKJsJkFI17YMHyQRtFSUMzcBqVBx4EQZF6gsqhVlK\nG34JPp8qxmR730xjnUPGt33OkawwUWFa6IMFxKMMaZMAcOMvCNhb0BrfQ0UFejalgBPQE1Ztzq27\nZiWYzrfDv2NGK+opAIR8hSkaxlnZ2deHPSTwDcHP/UPF68Yxelf+mKQgutAW468wK7RYH+3rAvrs\ntu1jSVeLzlvbTioIRRoTaIUVLYXbTcEKa2NCEJ9EZN4NA2a0S3NNdTWy5nS2wXau+J07/qmTteuk\n/142jGdIZa5O/a23vXN/D57SC4ZDL7N2bb0B+vu3XBqpZi+9vP7BOeZHVnYJrfh62x794hhXJC5Y\nz/2F+7CNTIqc9i1r1M7G0aJeR3F5iSO/JmXjKLQnE2DveV1bpCi5Q6pHNBxUW0e0SHpwxL8GfSr+\n5UrVS565+cr3sGqwFJSzDqEr8+PAkw4dPzuIJ8jxhVKqVSCLisFmplKpDgiOn6+1iF2jEisMKPyc\nIb9hrF5Sfolz9gL41vW5HUqaFIJkmMJ/9/aqdV1brejuP/RHdTFmgF7sC84MDf2nZJcayzYwXvp1\n5+Tt/D/AWRvnywwLAIUEZXThN7ewKC0ZpUJNMb0AjCOFOoCFEc6FJjjyL/r53YmAwBO/uYEuSROX\n02td");
    }

    public void restoreDataFromResource(String resourcePath, String license) {
        this.restoreDataFromResource(resourcePath, license, null);
    }

    public void restoreDataFromResource(String resourcePath, String license, @Nullable BiConsumer<String, String> copyFunction) {
        FuncTestTimer timer = TestInformationKit.pullTimer("XML Restore");
        String targetPath = this.getImportTargetPath(resourcePath);
        DataImportBean importBean = new DataImportBean();
        importBean.filePath = targetPath;
        importBean.licenseString = license;
        importBean.useDefaultPaths = false;
        importBean.quickImport = true;
        importBean.isSetup = false;
        if (copyFunction == null) {
            boolean baseUrlReplaced = this.xmlBackupCopier.copyXmlBackupFromClassPathTo(resourcePath, targetPath, Collections.emptyMap());
            if (baseUrlReplaced) {
                importBean.baseUrl = this.environmentData.getBaseUrl().toString();
            }
        } else {
            copyFunction.accept(resourcePath, targetPath);
        }
        this.createResource().path("dataImport").request().post(Entity.json((Object)importBean), String.class);
        timer.end();
    }

    private String getImportTargetPath(String resourcePath) {
        String importFileName = this.importFileNameFor((String)Preconditions.checkNotNull((Object)resourcePath));
        return this.getJiraHomePath() + FS + IMPORT + FS + importFileName;
    }

    private String getImportSourcePath(String resourcePath) {
        return RestoreDataResources.getResourceUrl(resourcePath).getFile();
    }

    private String importFileNameFor(String resourcePath) {
        String extension = FilenameUtils.getExtension((String)resourcePath);
        return extension != null ? resourcePath.hashCode() + "." + extension : resourcePath.hashCode() + ".xml";
    }

    public void turnOffDangerMode() {
        this.createResource().path("systemproperty").path("jira.dangermode").queryParam("value", new Object[]{"false"}).request().post(null);
    }

    public void turnOnDangerMode() {
        this.createResource().path("systemproperty").path("jira.dangermode").queryParam("value", new Object[]{"true"}).request().post(null);
    }

    private String getJiraHomePath() {
        return this.getImportConfig().jiraHome;
    }

    private ImportConfig getImportConfig() {
        ImportConfig config = JIRA_CONFIG.get();
        if (config == null) {
            WebTarget resource = this.createResource().path("dataImport/importConfig");
            config = DataImportControl.getWithStartupRetry(resource, ImportConfig.class);
            JIRA_CONFIG.set(config);
        }
        return config;
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    static class ImportConfig {
        public String jiraHome;
        public int buildNumber;

        ImportConfig() {
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    static class DataImportBean {
        public String filePath;
        public String licenseString;
        public boolean quickImport;
        @Deprecated
        public boolean useDefaultPaths;
        @Deprecated
        public boolean isSetup;
        public String baseUrl;

        DataImportBean() {
        }
    }
}

