/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client;

import com.atlassian.applinks.api.application.jira.JiraProjectEntityType;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.ApplinksPluginRestClient;
import com.google.common.base.Preconditions;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.ws.rs.client.Entity;
import org.json.JSONException;
import org.json.JSONObject;

public class EntityLinkControl {
    private static final String CONFLUENCE_SPACE_TYPE_ID = "confluence.space";
    private static final String FALSE = Boolean.toString(false);
    private static final String JIRA_PROJECT_ENTITY_TYPE = JiraProjectEntityType.class.getName();
    private final ApplinksPluginRestClient applinksBackdoor;

    private static String getEntityJsonForConfluenceSpace(String confluenceSpaceKey, String confluenceSpaceName, UUID applicationId) {
        Preconditions.checkNotNull((Object)applicationId);
        Preconditions.checkNotNull((Object)confluenceSpaceKey);
        Preconditions.checkNotNull((Object)confluenceSpaceName);
        try {
            JSONObject entityLink = new JSONObject();
            entityLink.put("applicationId", (Object)applicationId);
            entityLink.put("typeId", (Object)CONFLUENCE_SPACE_TYPE_ID);
            entityLink.put("name", (Object)confluenceSpaceName);
            entityLink.put("key", (Object)confluenceSpaceKey);
            return entityLink.toString();
        }
        catch (JSONException e) {
            throw new IllegalStateException(e);
        }
    }

    public EntityLinkControl(@Nonnull JIRAEnvironmentData jiraEnvironment) {
        this.applinksBackdoor = new ApplinksPluginRestClient(jiraEnvironment);
    }

    public void linkProjectToConfluenceSpace(@Nonnull String jiraProjectKey, @Nonnull UUID applicationId, @Nonnull String confluenceSpaceKey, @Nonnull String confluenceSpaceName) {
        String confluenceSpaceJson = EntityLinkControl.getEntityJsonForConfluenceSpace(confluenceSpaceKey, confluenceSpaceName, applicationId);
        this.createEntityLink(JIRA_PROJECT_ENTITY_TYPE, jiraProjectKey, confluenceSpaceJson);
    }

    private void createEntityLink(@Nonnull String localEntityType, @Nonnull String localKey, @Nonnull String remoteEntityJSON) {
        Preconditions.checkNotNull((Object)localKey);
        this.applinksBackdoor.rootResource().path("entitylink").path(localEntityType).path(localKey).queryParam("reciprocate", new Object[]{FALSE}).request(new String[]{"application/json"}).put(Entity.json((Object)remoteEntityJSON));
    }
}

