/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client;

import com.atlassian.jira.testkit.client.BackdoorControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.annotation.Nonnull;

public class IndexingControl
extends BackdoorControl<IndexingControl> {
    private static final int POLL_INTERVAL = 10;

    public IndexingControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    @Nonnull
    public IndexingProgress startInBackground() {
        this.createResource().path("indexing").path("background").request().post(null);
        return new IndexingProgress();
    }

    boolean isIndexingInProgress() {
        return (Boolean)this.createResource().path("indexing").request().get(Boolean.class);
    }

    public boolean isIndexConsistent() {
        return (Boolean)this.createResource().path("indexing").path("consistent").request().get(Boolean.class);
    }

    public void deleteIndex() {
        this.createResource().path("indexing").path("deleteIndex").request().post(null);
    }

    public void reindexAll() {
        this.createResource().path("indexing").path("reindexAll").request().post(null);
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public class IndexingProgress {
        public void waitForCompletion() {
            while (IndexingControl.this.isIndexingInProgress()) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

