/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client;

import com.atlassian.jira.permission.JiraPermissionHolderType;
import com.atlassian.jira.testkit.client.BackdoorControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;

public class IssueSecuritySchemesControl
extends BackdoorControl<IssueSecuritySchemesControl> {
    public IssueSecuritySchemesControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public Long createScheme(String schemeName, String description) {
        return Long.parseLong((String)this.createResource().path("issueSecuritySchemes/create").queryParam("schemeName", new Object[]{schemeName}).queryParam("schemeDescription", new Object[]{description}).request().get(String.class));
    }

    public void deleteScheme(long schemeId) {
        this.createResource().path("issueSecuritySchemes").path(String.valueOf(schemeId)).request().delete();
    }

    public Long addSecurityLevel(long schemeId, String name, String description) {
        return Long.parseLong((String)this.createResource().path("issueSecuritySchemes").path(String.valueOf(schemeId)).queryParam("name", new Object[]{name}).queryParam("description", new Object[]{description}).request().post(null, String.class));
    }

    public void addUserToSecurityLevel(long schemeId, long levelId, String userKey) {
        this.createResource().path("issueSecuritySchemes").path(String.valueOf(schemeId)).path(String.valueOf(levelId)).queryParam("userKey", new Object[]{userKey}).request().post(null);
    }

    public void deleteUserFromSecurityLevel(long schemeId, long levelId, String userKey) {
        this.createResource().path("issueSecuritySchemes").path(String.valueOf(schemeId)).path(String.valueOf(levelId)).path(JiraPermissionHolderType.USER.getKey()).path(userKey).request().delete();
    }

    public void deleteSecurityLevel(long schemeId, long securityLevelId) {
        this.createResource().path("issueSecuritySchemes").path(String.valueOf(schemeId)).path(String.valueOf(securityLevelId)).request().delete();
    }

    public void deleteUserCustomFieldFromSecurityLevel(long schemeId, long levelId, String customField) {
        this.createResource().path("issueSecuritySchemes").path(String.valueOf(schemeId)).path(String.valueOf(levelId)).path(JiraPermissionHolderType.USER_CUSTOM_FIELD.getKey()).path(customField).request().delete();
    }
}

