/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client;

import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.rest.api.issue.IssueFields;
import com.atlassian.jira.rest.api.issue.IssueUpdateRequest;
import com.atlassian.jira.rest.api.issue.ResourceRef;
import com.atlassian.jira.testkit.client.BackdoorControl;
import com.atlassian.jira.testkit.client.IssueTypeControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Attachment;
import com.atlassian.jira.testkit.client.restclient.Comment;
import com.atlassian.jira.testkit.client.restclient.CommentClient;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.IssuesExtClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.Visibility;
import com.atlassian.jira.testkit.client.restclient.Worklog;
import com.atlassian.jira.testkit.client.restclient.WorklogClient;
import com.atlassian.jira.util.collect.MapBuilder;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.junit.Assert;

@ParametersAreNonnullByDefault
public class IssuesControl
extends BackdoorControl<IssuesControl> {
    public static final long HSP_PROJECT_ID = 10000L;
    public static final long MKY_PROJECT_ID = 10001L;
    private static final String DEFAULT_PRIORITY = "1";
    private final IssueClient issueClient;
    private final CommentClient commentClient;
    private final IssueTypeControl issueTypeControl;
    private final IssuesExtClient issuesExtClient;
    private final WorklogClient worklogClient;

    public IssuesControl(JIRAEnvironmentData environmentData, IssueTypeControl issueTypeControl) {
        super(environmentData);
        this.issueTypeControl = issueTypeControl;
        this.issueClient = new IssueClient(environmentData);
        this.commentClient = new CommentClient(environmentData);
        this.issuesExtClient = new IssuesExtClient(environmentData);
        this.worklogClient = new WorklogClient(environmentData);
    }

    @Deprecated
    public IssueCreateResponse createIssue(long projectId, String summary) {
        return this.createIssue(projectId, summary, null);
    }

    public IssueCreateResponse createSubtask(String projectId, String parentKey, String summary) {
        IssueTypeControl.IssueType issueType = (IssueTypeControl.IssueType)Iterables.find(this.issueTypeControl.getIssueTypes(), type -> type.getName().equals("Sub-task"));
        IssueFields fields = new IssueFields();
        fields.project(ResourceRef.withId((String)("" + projectId)));
        fields.parent(ResourceRef.withKey((String)parentKey));
        fields.issueType(ResourceRef.withId((String)issueType.getId()));
        fields.priority(ResourceRef.withId((String)DEFAULT_PRIORITY));
        fields.summary(summary);
        IssueUpdateRequest issue = new IssueUpdateRequest();
        return this.issueClient.create(issue.fields(fields));
    }

    public IssuesControl setDescription(String issueKey, String description) {
        IssueUpdateRequest fields = new IssueUpdateRequest().fields(new IssueFields().description(description));
        this.issueClient.update(issueKey, fields);
        return this;
    }

    public IssueCreateResponse createIssue(String projectKey, String summary) {
        return this.createIssue(projectKey, summary, null, DEFAULT_PRIORITY, this.getBestGuessIssueType(Optional.of(projectKey)));
    }

    @Deprecated
    public IssueCreateResponse createIssue(long projectId, String summary, @Nullable String assignee) {
        IssueFields fields = new IssueFields();
        fields.project(ResourceRef.withId((String)String.valueOf(projectId)));
        fields.issueType(ResourceRef.withId((String)this.getBestGuessIssueType(Optional.of(Long.toString(projectId)))));
        fields.priority(ResourceRef.withId((String)DEFAULT_PRIORITY));
        fields.summary(summary);
        if (assignee != null) {
            fields.assignee(ResourceRef.withName((String)assignee));
        }
        return this.issueClient.create(new IssueUpdateRequest().fields(fields));
    }

    public IssueCreateResponse createIssue(String projectKey, String summary, String assignee) {
        return this.createIssue(projectKey, summary, assignee, DEFAULT_PRIORITY, this.getBestGuessIssueType(Optional.of(projectKey)));
    }

    public IssueCreateResponse createIssue(String projectKey, String summary, @Nullable String assignee, String priority, String issueType) {
        return this.createIssue(projectKey, summary, null, assignee, priority, issueType);
    }

    public IssueCreateResponse createIssue(String projectKey, String summary, @Nullable String description, @Nullable String assignee, String priority, String issueType) {
        return this.createIssue(projectKey, summary, description, assignee, priority, issueType, false);
    }

    public IssueCreateResponse createIssue(String projectKey, String summary, @Nullable String description, @Nullable String assignee, String priority, String issueType, boolean updateHistory) {
        IssueFields fields = new IssueFields();
        fields.project(ResourceRef.withKey((String)projectKey));
        fields.issueType(StringUtils.isNumeric((String)issueType) ? ResourceRef.withId((String)issueType) : ResourceRef.withName((String)issueType));
        fields.priority(StringUtils.isNumeric((String)priority) ? ResourceRef.withId((String)priority) : ResourceRef.withName((String)priority));
        fields.summary(summary);
        if (description != null) {
            fields.description(description);
        }
        if (assignee != null) {
            fields.assignee(ResourceRef.withName((String)assignee));
        }
        return this.issueClient.create(new IssueUpdateRequest().fields(fields), updateHistory);
    }

    public IssueCreateResponse createIssue(@Nonnull String projectKey, @Nonnull String summary, @Nullable String description, @Nonnull IssueFields fields, boolean updateHistory) {
        fields.project(ResourceRef.withKey((String)projectKey));
        fields.summary(summary);
        if (description != null) {
            fields.description(description);
        }
        return this.issueClient.create(new IssueUpdateRequest().fields(fields), updateHistory);
    }

    @Nonnull
    private String getBestGuessIssueType(Optional<String> projectIdOrKey) {
        List<IssueTypeControl.IssueType> issueTypes = projectIdOrKey.map(this.issueTypeControl::getIssueTypesForProject).orElse(this.issueTypeControl.getIssueTypes());
        Optional<IssueTypeControl.IssueType> issueType = issueTypes.stream().filter(type -> !type.isSubtask() && !type.getName().equals("Epic")).findFirst();
        if (!issueType.isPresent()) {
            throw new UnsupportedOperationException("Can't create issue due to no default issue types");
        }
        return issueType.get().getId();
    }

    public ParsedResponse<Comment> commentIssue(String issueKey, String comment) {
        return this.commentIssueWithVisibility(issueKey, comment, "group", "jira-administrators");
    }

    public ParsedResponse<Comment> commentIssueWithVisibility(String issueKey, String comment, String restrictedType, String restrictedParam) {
        Comment newComment = new Comment();
        newComment.body = comment;
        newComment.visibility = new Visibility(restrictedType, restrictedParam);
        return this.commentClient.post(issueKey, newComment);
    }

    public ParsedResponse<Comment> updateComment(String issueKey, String commentId, String comment, String restrictedType, String restrictedParam) {
        Comment update = new Comment();
        update.id = commentId;
        update.body = comment;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)restrictedType) && !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)restrictedParam)) {
            update.visibility = new Visibility(restrictedType, restrictedParam);
        }
        return this.commentClient.put(issueKey, update);
    }

    public ParsedResponse deleteComment(String issueKey, String commentId) {
        return this.commentClient.delete(issueKey, commentId);
    }

    public ParsedResponse<List<Attachment>> attachFile(String issueKey, File file) {
        return this.issueClient.attachFile(issueKey, file);
    }

    public void assignIssue(String issueKey, String username) {
        IssueUpdateRequest updateSummaryRequest = new IssueUpdateRequest().fields(new IssueFields().assignee(ResourceRef.withName((String)username)));
        this.issueClient.update(issueKey, updateSummaryRequest);
    }

    public Issue getIssue(String issueKey, Issue.Expand ... expand) {
        return this.getIssue(issueKey, false, expand);
    }

    public Issue getIssue(String issueKey, boolean updateHistory, Issue.Expand ... expand) {
        return this.issueClient.get(issueKey, updateHistory, expand);
    }

    public void transitionIssue(String issueKey, int transitionId) {
        ResourceRef transition = ResourceRef.withId((String)String.valueOf(transitionId));
        IssueUpdateRequest updateSummaryRequest = new IssueUpdateRequest().transition(transition);
        this.issueClient.transition(issueKey, updateSummaryRequest);
    }

    public IssuesControl addLabel(String issueKey, String label) {
        Map add = MapBuilder.newBuilder().add((Object)"add", (Object)label).toMap();
        List<Map> addList = Collections.singletonList(add);
        Map labels = MapBuilder.newBuilder().add((Object)"labels", addList).toMap();
        Map update = MapBuilder.newBuilder().add((Object)"update", (Object)labels).toMap();
        ParsedResponse response = this.issueClient.update(issueKey, update);
        Assert.assertEquals((String)("Update failed. " + response.toString()), (long)204L, (long)response.statusCode);
        return this;
    }

    public IssuesControl setSummary(String issueKey, String summary) {
        IssueUpdateRequest updateSummaryRequest = new IssueUpdateRequest().fields(new IssueFields().summary(summary));
        ParsedResponse response = this.issueClient.updateResponse(issueKey, updateSummaryRequest);
        Assert.assertEquals((String)("Update failed. " + response.toString()), (long)204L, (long)response.statusCode);
        return this;
    }

    public IssuesControl setIssueFields(String issueKey, IssueFields issueFields) {
        IssueUpdateRequest updateRequest = new IssueUpdateRequest().fields(issueFields);
        ParsedResponse response = this.issueClient.updateResponse(issueKey, updateRequest);
        Assert.assertEquals((String)("Update failed. " + response.toString()), (long)204L, (long)response.statusCode);
        return this;
    }

    public ParsedResponse deleteIssue(String issueKey, boolean deleteSubtasks) throws WebApplicationException {
        return this.issueClient.delete(issueKey, Boolean.toString(deleteSubtasks));
    }

    public Response archiveIssue(String issueIdOrKey) {
        return this.issueClient.archive(issueIdOrKey);
    }

    public Response restoreIssue(String issueIdOrKey) {
        return this.issueClient.restore(issueIdOrKey);
    }

    public void touch(String key) {
        this.issuesExtClient.touch(key);
    }

    public void changeUpdated(String key, Date date) {
        this.issuesExtClient.changeUpdated(key, date);
    }

    public void changeCreated(String key, Date date) {
        this.issuesExtClient.changeCreated(key, date);
    }

    @Override
    public IssuesControl loginAs(String username) {
        this.commentClient.loginAs(username);
        this.issueClient.loginAs(username);
        return (IssuesControl)super.loginAs(username);
    }

    @Override
    public IssuesControl loginAs(String username, String password) {
        this.commentClient.loginAs(username, password);
        this.issueClient.loginAs(username, password);
        return (IssuesControl)super.loginAs(username, password);
    }

    @Override
    public IssuesControl anonymous() {
        super.anonymous();
        this.issueClient.anonymous();
        return this;
    }

    public Issue getIssue(String key) {
        return this.issueClient.get(key, new Issue.Expand[0]);
    }

    public IssuesControl addFixVersion(String issueKey, String version) {
        return this.updateVersionField(issueKey, "fixVersions", version, "add");
    }

    public IssuesControl removeFixVersion(String issueKey, String version) {
        return this.updateVersionField(issueKey, "fixVersions", version, "remove");
    }

    public IssuesControl addAffectsVersion(String issueKey, String version) {
        return this.updateVersionField(issueKey, "versions", version, "add");
    }

    public ParsedResponse<Worklog> addWorklogItem(String issueKey, Long timeSpentSeconds) {
        Worklog worklog = new Worklog();
        worklog.timeSpent = timeSpentSeconds.toString();
        return this.worklogClient.post(issueKey, worklog);
    }

    private IssuesControl updateVersionField(String issueKey, String fieldId, String version, String operation) {
        Map add = MapBuilder.newBuilder().add((Object)operation, (Object)MapBuilder.newBuilder().add((Object)"name", (Object)version).toMap()).toMap();
        List<Map> addList = Collections.singletonList(add);
        Map versions = MapBuilder.newBuilder().add((Object)fieldId, addList).toMap();
        Map update = MapBuilder.newBuilder().add((Object)"update", (Object)versions).toMap();
        ParsedResponse response = this.issueClient.update(issueKey, update);
        Assert.assertEquals((String)("Update failed. " + response.toString()), (long)204L, (long)response.statusCode);
        return this;
    }
}

