/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client;

import com.atlassian.jira.notification.type.NotificationType;
import com.atlassian.jira.testkit.client.BackdoorControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;

public class NotificationSchemesControl
extends BackdoorControl<NotificationSchemesControl> {
    public NotificationSchemesControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public Long copyDefaultScheme(String schemeName) {
        return Long.parseLong((String)this.createResource().path("notificationSchemes/copyDefault").queryParam("schemeName", new Object[]{schemeName}).request().get(String.class));
    }

    public Long createScheme(String schemeName, String description) {
        return Long.parseLong((String)this.createResource().path("notificationSchemes/create").queryParam("schemeName", new Object[]{schemeName}).queryParam("schemeDescription", new Object[]{description}).request().get(String.class));
    }

    public void deleteScheme(long schemeId) {
        this.createResource().path("notificationSchemes").path(String.valueOf(schemeId)).request().delete();
    }

    public void addGroupNotification(Long schemeId, long eventTypeId, String groupName) {
        this.addNotification(schemeId, eventTypeId, NotificationType.GROUP.dbCode(), groupName);
    }

    public void removeGroupNotification(long schemeId, long eventTypeId, String groupName) {
        this.removeNotification(schemeId, eventTypeId, NotificationType.GROUP.dbCode(), groupName);
    }

    public void addProjectRoleNotification(long schemeId, long eventTypeId, long projectRoleId) {
        this.addNotification(schemeId, eventTypeId, NotificationType.PROJECT_ROLE.dbCode(), Long.toString(projectRoleId));
    }

    public void removeProjectRoleNotification(long schemeId, long eventTypeId, long projectRoleId) {
        this.removeNotification(schemeId, eventTypeId, NotificationType.PROJECT_ROLE.dbCode(), Long.toString(projectRoleId));
    }

    public void addUserNotification(long schemeId, long eventTypeId, String userName) {
        this.addNotification(schemeId, eventTypeId, NotificationType.SINGLE_USER.dbCode(), userName);
    }

    public void removeUserNotification(long schemeId, long eventTypeId, String userName) {
        this.removeNotification(schemeId, eventTypeId, NotificationType.SINGLE_USER.dbCode(), userName);
    }

    public void addEmailNotification(long schemeId, long eventTypeId, String email) {
        this.addNotification(schemeId, eventTypeId, NotificationType.SINGLE_EMAIL_ADDRESS.dbCode(), email);
    }

    public void removeEmailNotification(long schemeId, long eventTypeId, String email) {
        this.removeNotification(schemeId, eventTypeId, NotificationType.SINGLE_EMAIL_ADDRESS.dbCode(), email);
    }

    public void addUserCustomField(long schemeId, long eventTypeId, String customFieldId) {
        this.addNotification(schemeId, eventTypeId, NotificationType.USER_CUSTOM_FIELD_VALUE.dbCode(), customFieldId);
    }

    public void removeUserCustomField(long schemeId, long eventTypeId, String customFieldId) {
        this.removeNotification(schemeId, eventTypeId, NotificationType.USER_CUSTOM_FIELD_VALUE.dbCode(), customFieldId);
    }

    public void replaceGroupNotifications(long schemeId, long eventTypeId, String groupName) {
        this.replaceNotifications(schemeId, eventTypeId, NotificationType.GROUP.dbCode(), groupName);
    }

    private void addNotification(long schemeId, long eventTypeId, String type, String parameter) {
        this.get(this.createResource().path("notificationSchemes/entity/add").queryParam("schemeId", new Object[]{"" + schemeId}).queryParam("eventTypeId", new Object[]{"" + eventTypeId}).queryParam("type", new Object[]{type}).queryParam("parameter", new Object[]{parameter}));
    }

    private void removeNotification(long schemeId, long eventTypeId, String type, String parameter) {
        this.get(this.createResource().path("notificationSchemes/entity/remove").queryParam("schemeId", new Object[]{"" + schemeId}).queryParam("eventTypeId", new Object[]{"" + eventTypeId}).queryParam("type", new Object[]{type}).queryParam("parameter", new Object[]{parameter}));
    }

    private void replaceNotifications(long schemeId, long eventTypeId, String type, String parameter) {
        this.get(this.createResource().path("notificationSchemes/entity/replace").queryParam("schemeId", new Object[]{"" + schemeId}).queryParam("eventTypeId", new Object[]{"" + eventTypeId}).queryParam("type", new Object[]{type}).queryParam("parameter", new Object[]{parameter}));
    }
}

