/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client;

import com.atlassian.jira.permission.JiraPermissionHolderType;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.testkit.beans.PermissionSchemeBean;
import com.atlassian.jira.testkit.client.BackdoorControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.ws.rs.client.WebTarget;

public class PermissionSchemesControl
extends BackdoorControl<PermissionSchemesControl> {
    public PermissionSchemesControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public Long copyDefaultScheme(String schemeName) {
        return Long.parseLong((String)this.createResource().path("permissionSchemes/copyDefault").queryParam("schemeName", new Object[]{schemeName}).request().get(String.class));
    }

    public Long copyScheme(String sourceSchemeName, String newSchemeName) {
        return Long.parseLong((String)this.createResource().path("permissionSchemes").path("copy").path(sourceSchemeName).path(newSchemeName).request().post(null, String.class));
    }

    public Long createScheme(String schemeName, String description) {
        return Long.parseLong((String)this.createResource().path("permissionSchemes/create").queryParam("schemeName", new Object[]{schemeName}).queryParam("schemeDescription", new Object[]{description}).request().get(String.class));
    }

    public void deleteScheme(long schemeId) {
        this.createResource().path("permissionSchemes").path(String.valueOf(schemeId)).request().delete();
    }

    public PermissionRequestBuilder addPermission(long schemeId, ProjectPermissionKey permission, String type) {
        return new PermissionRequestBuilder("entity/add").schemeId(schemeId).permission(permission).type(type);
    }

    public PermissionRequestBuilder addPermission(long schemeId, ProjectPermissionKey permission, JiraPermissionHolderType type) {
        return this.addPermission(schemeId, permission, type.getKey());
    }

    public PermissionRequestBuilder removePermission(long schemeId, ProjectPermissionKey permission, String type) {
        return new PermissionRequestBuilder("entity/remove").schemeId(schemeId).permission(permission).type(type);
    }

    public PermissionRequestBuilder removePermission(long schemeId, ProjectPermissionKey permission, JiraPermissionHolderType type) {
        return this.removePermission(schemeId, permission, type.getKey());
    }

    public PermissionRequestBuilder replacePermission(long schemeId, ProjectPermissionKey permission, String type) {
        return new PermissionRequestBuilder("entity/replace").schemeId(schemeId).permission(permission).type(type);
    }

    public PermissionRequestBuilder replacePermission(long schemeId, ProjectPermissionKey permission, JiraPermissionHolderType type) {
        return this.replacePermission(schemeId, permission, type.getKey());
    }

    public PermissionSchemeBean getAssignedPermissions(long schemeId) {
        String response = new PermissionRequestBuilder(Long.toString(schemeId)).getRequest();
        try {
            ObjectMapper mapper = new ObjectMapper();
            return (PermissionSchemeBean)mapper.readValue(response, PermissionSchemeBean.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public void addUserPermission(long schemeId, int permission, String userName) {
        this.addPermission(schemeId, permission, JiraPermissionHolderType.USER.getKey(), userName);
    }

    public void addUserPermission(long schemeId, ProjectPermissionKey permission, String userName) {
        this.addPermission(schemeId, permission, JiraPermissionHolderType.USER).parameter(userName).getRequest();
    }

    @Deprecated
    public void removeUserPermission(long schemeId, int permission, String userName) {
        this.removePermission(schemeId, permission, JiraPermissionHolderType.USER.getKey(), userName);
    }

    public void removeUserPermission(long schemeId, ProjectPermissionKey permission, String userName) {
        this.removePermission(schemeId, permission, JiraPermissionHolderType.USER).parameter(userName).getRequest();
    }

    public void replaceUserPermission(long schemeId, ProjectPermissionKey permission, String userName) {
        this.replacePermission(schemeId, permission, JiraPermissionHolderType.USER).parameter(userName).getRequest();
    }

    public void addUserCustomFieldPermission(long schemeId, ProjectPermissionKey permission, String customFieldName) {
        this.addPermission(schemeId, permission, JiraPermissionHolderType.USER_CUSTOM_FIELD).parameter(customFieldName).getRequest();
    }

    public void removeUserCustomFieldPermission(long schemeId, ProjectPermissionKey permission, String customFieldName) {
        this.removePermission(schemeId, permission, JiraPermissionHolderType.USER_CUSTOM_FIELD).parameter(customFieldName).getRequest();
    }

    public void replaceUserCustomFieldPermissions(long schemeId, ProjectPermissionKey permission, String customFieldName) {
        this.replacePermission(schemeId, permission, JiraPermissionHolderType.USER_CUSTOM_FIELD).parameter(customFieldName).getRequest();
    }

    public void addCurrentAssigneePermission(long schemeId, @Nonnull ProjectPermissionKey permission) {
        this.addPermission(schemeId, permission, "assignee").getRequest();
    }

    public void addApplicationRolePermission(long schemeId, @Nonnull ProjectPermissionKey permission, @Nonnull String applicationRole) {
        this.addPermission(schemeId, permission, "applicationRole").parameter(applicationRole).getRequest();
    }

    public void addReporterPermission(long schemeId, @Nonnull ProjectPermissionKey permission) {
        this.addPermission(schemeId, permission, "reporter").getRequest();
    }

    @Deprecated
    public void addGroupPermission(Long schemeId, int permission, String groupName) {
        this.addPermission(schemeId, permission, JiraPermissionHolderType.GROUP.getKey(), groupName);
    }

    public void addGroupPermission(Long schemeId, ProjectPermissionKey permission, String groupName) {
        this.addPermission((long)schemeId, permission, JiraPermissionHolderType.GROUP).parameter(groupName).getRequest();
    }

    @Deprecated
    public void removeGroupPermission(long schemeId, int permission, String groupName) {
        this.removePermission(schemeId, permission, JiraPermissionHolderType.GROUP.getKey(), groupName);
    }

    public void removeGroupPermission(long schemeId, ProjectPermissionKey permission, String groupName) {
        this.removePermission(schemeId, permission, JiraPermissionHolderType.GROUP).parameter(groupName).getRequest();
    }

    @Deprecated
    public void replaceGroupPermissions(long schemeId, int permission, String groupName) {
        this.replacePermissions(schemeId, permission, JiraPermissionHolderType.GROUP.getKey(), groupName);
    }

    public void replaceGroupPermissions(long schemeId, ProjectPermissionKey permission, String groupName) {
        this.replacePermission(schemeId, permission, JiraPermissionHolderType.GROUP).parameter(groupName).getRequest();
    }

    @Deprecated
    public void addProjectRolePermission(long schemeId, int permission, long projectRoleId) {
        this.addPermission(schemeId, permission, JiraPermissionHolderType.PROJECT_ROLE.getKey(), Long.toString(projectRoleId));
    }

    public void addProjectRolePermission(long schemeId, ProjectPermissionKey permission, long projectRoleId) {
        this.addPermission(schemeId, permission, JiraPermissionHolderType.PROJECT_ROLE).parameter(Long.toString(projectRoleId)).getRequest();
    }

    @Deprecated
    public void removeProjectRolePermission(long schemeId, int permission, long projectRoleId) {
        this.removePermission(schemeId, permission, JiraPermissionHolderType.PROJECT_ROLE.getKey(), Long.toString(projectRoleId));
    }

    public void removeProjectRolePermission(long schemeId, ProjectPermissionKey permission, long projectRoleId) {
        this.removePermission(schemeId, permission, JiraPermissionHolderType.PROJECT_ROLE).parameter(Long.toString(projectRoleId)).getRequest();
    }

    public void replaceProjectRolePermission(long schemeId, ProjectPermissionKey permission, long projectRoleId) {
        this.replacePermission(schemeId, permission, JiraPermissionHolderType.PROJECT_ROLE).parameter(Long.toString(projectRoleId)).getRequest();
    }

    public void addProjectLeadPermission(long schemeId, ProjectPermissionKey permission) {
        this.addPermission(schemeId, permission, JiraPermissionHolderType.PROJECT_LEAD).getRequest();
    }

    public void removeProjectLeadPermission(long schemeId, ProjectPermissionKey permission) {
        this.removePermission(schemeId, permission, JiraPermissionHolderType.PROJECT_LEAD).getRequest();
    }

    public void replaceProjectLeadPermission(long schemeId, ProjectPermissionKey permission) {
        this.replacePermission(schemeId, permission, JiraPermissionHolderType.PROJECT_LEAD).getRequest();
    }

    public void addEveryonePermission(Long schemeId, ProjectPermissionKey permission) {
        this.addPermission((long)schemeId, permission, JiraPermissionHolderType.GROUP).getRequest();
    }

    public void removeEveryonePermission(Long schemeId, ProjectPermissionKey permission) {
        this.removePermission((long)schemeId, permission, JiraPermissionHolderType.GROUP).getRequest();
    }

    public void addUserCustomFieldPermission(Long schemeId, ProjectPermissionKey permission, String fieldId) {
        this.addPermission((long)schemeId, permission, JiraPermissionHolderType.USER_CUSTOM_FIELD.getKey()).parameter(fieldId).getRequest();
    }

    public void addGroupCustomFieldPermission(Long schemeId, ProjectPermissionKey permission, String fieldId) {
        this.addPermission((long)schemeId, permission, JiraPermissionHolderType.GROUP_CUSTOM_FIELD.getKey()).parameter(fieldId).getRequest();
    }

    private void addPermission(long schemeId, int permission, String type, String parameter) {
        this.get(this.createResource().path("permissionSchemes/legacy/entity/add").queryParam("schemeId", new Object[]{"" + schemeId}).queryParam("permission", new Object[]{"" + permission}).queryParam("type", new Object[]{type}).queryParam("parameter", new Object[]{parameter}));
    }

    private void removePermission(long schemeId, int permission, String type, String parameter) {
        this.get(this.createResource().path("permissionSchemes/legacy/entity/remove").queryParam("schemeId", new Object[]{"" + schemeId}).queryParam("permission", new Object[]{"" + permission}).queryParam("type", new Object[]{type}).queryParam("parameter", new Object[]{parameter}));
    }

    private void replacePermissions(long schemeId, int permission, String type, String parameter) {
        this.get(this.createResource().path("permissionSchemes/legacy/entity/replace").queryParam("schemeId", new Object[]{"" + schemeId}).queryParam("permission", new Object[]{"" + permission}).queryParam("type", new Object[]{type}).queryParam("parameter", new Object[]{parameter}));
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public class PermissionRequestBuilder {
        private static final String BASE_URL = "permissionSchemes/";
        private final String requestUrl;
        private Long schemeId = null;
        private ProjectPermissionKey permission = null;
        private String type = null;
        private String parameter = null;

        public PermissionRequestBuilder(String endpoint) {
            this.requestUrl = BASE_URL + endpoint;
        }

        public PermissionRequestBuilder schemeId(Long schemeId) {
            this.schemeId = schemeId;
            return this;
        }

        public PermissionRequestBuilder permission(ProjectPermissionKey permission) {
            this.permission = permission;
            return this;
        }

        public PermissionRequestBuilder type(JiraPermissionHolderType type) {
            this.type = type.getKey();
            return this;
        }

        public PermissionRequestBuilder type(String type) {
            this.type = type;
            return this;
        }

        public PermissionRequestBuilder parameter(String parameter) {
            this.parameter = parameter;
            return this;
        }

        public String getRequest() {
            return PermissionSchemesControl.this.get(this.buildRequestResource(this.requestUrl));
        }

        private WebTarget buildRequestResource(String path) {
            WebTarget resource = PermissionSchemesControl.this.createResource().path(path);
            if (this.schemeId != null) {
                resource = resource.queryParam("schemeId", new Object[]{"" + this.schemeId});
            }
            if (this.permission != null) {
                resource = resource.queryParam("permission", new Object[]{"" + this.permission.permissionKey()});
            }
            if (this.type != null) {
                resource = resource.queryParam("type", new Object[]{this.type});
            }
            if (this.parameter != null) {
                resource = resource.queryParam("parameter", new Object[]{this.parameter});
            }
            return resource;
        }
    }
}

