/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client;

import com.atlassian.jira.testkit.client.BackdoorControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;

public class PluginsControl
extends BackdoorControl<PluginsControl> {
    public PluginsControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public String getPluginState(String pluginKey) {
        WebTarget resource = this.createResource().path("plugins/state").queryParam("key", new Object[]{pluginKey});
        return (String)resource.request().get(String.class);
    }

    public void disablePlugin(String pluginKey) {
        WebTarget resource = this.createResource().path("plugins/disable").queryParam("key", new Object[]{pluginKey});
        this.get(resource);
    }

    public void enablePlugin(String pluginKey) {
        WebTarget resource = this.createResource().path("plugins/enable").queryParam("key", new Object[]{pluginKey});
        this.get(resource);
    }

    public void disablePluginModule(String completeKey) {
        WebTarget resource = this.createResource().path("plugins/disableModule").queryParam("key", new Object[]{completeKey});
        this.get(resource);
    }

    public void enablePluginModule(String completeKey) {
        WebTarget resource = this.createResource().path("plugins/enableModule").queryParam("key", new Object[]{completeKey});
        this.get(resource);
    }

    public void setPluginLicense(String pluginKey, String license) throws JSONException {
        pluginKey = pluginKey + "-key";
        JSONObject licenseDetails = new JSONObject();
        licenseDetails.put("rawLicense", (Object)license);
        this.createResourceForPath("plugins").path(pluginKey + "/license").request(new String[]{"application/vnd.atl.plugins+json"}).put(Entity.entity((Object)licenseDetails.toString(), (String)"application/vnd.atl.plugins+json"));
    }

    public void setSettings(String key, String value) {
        this.createResource().path("plugins/settings").path(key).request().put(Entity.json((Object)value));
    }

    public String getSettings(String key) {
        return (String)this.createResource().path("plugins/settings").path(key).request().get(String.class);
    }

    public void clearSettings(String key) {
        this.createResource().path("plugins/settings").path(key).request().delete();
    }
}

