/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client;

import com.atlassian.jira.testkit.beans.Priority;
import com.atlassian.jira.testkit.client.BackdoorControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;

public class PriorityControl
extends BackdoorControl<PriorityControl> {
    private static final GenericType<List<Priority>> LIST_GENERIC_TYPE = new GenericType<List<Priority>>(){};

    public PriorityControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public Priority createPriority(String name, String description, String color, String iconUrl) {
        Priority priority = new Priority();
        priority.setName(name);
        priority.setDescription(description);
        priority.setColor(color);
        priority.setIconUrl(iconUrl);
        return (Priority)this.createPriorityResource().request().post(Entity.json((Object)priority), Priority.class);
    }

    public Priority editPriority(long id, String name, String description, String color, String iconUrl) {
        Priority priority = new Priority();
        priority.setId(String.valueOf(id));
        priority.setName(name);
        priority.setDescription(description);
        priority.setColor(color);
        priority.setIconUrl(iconUrl);
        return (Priority)this.createPriorityResource().request().put(Entity.json((Object)priority), Priority.class);
    }

    public List<Priority> getPriorities() {
        return (List)this.createPriorityResource().request().get(LIST_GENERIC_TYPE);
    }

    public void deletePriority(long id) {
        this.createPriorityResource().path(String.valueOf(id)).request().delete();
    }

    public void setDefaultPriority(long id) {
        this.createPriorityResource().path(String.valueOf(id)).path("default").request().post(null);
    }

    public void movePriorityUp(long id) {
        this.createPriorityResource().path(String.valueOf(id)).path("up").request().post(null);
    }

    public void movePriorityDown(long id) {
        this.createPriorityResource().path(String.valueOf(id)).path("down").request().post(null);
    }

    private WebTarget createPriorityResource() {
        return this.createResource().path("priority");
    }
}

