/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client;

import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.testkit.beans.EntityList;
import com.atlassian.jira.testkit.beans.ProjectSchemesBean;
import com.atlassian.jira.testkit.client.BackdoorControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.ws.rs.client.WebTarget;

public class ProjectControl
extends BackdoorControl<ProjectControl> {
    public ProjectControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public long addProject(String name, String key, String lead) {
        return this.addProject(name, key, lead, "business");
    }

    public long addProject(String name, String key, String lead, String projectType) {
        String s = (String)this.createResource().path("project/add").queryParam("name", new Object[]{name}).queryParam("key", new Object[]{key}).queryParam("lead", new Object[]{lead}).queryParam("type", new Object[]{projectType}).request().get(String.class);
        return Long.parseLong(s);
    }

    public long addProjectWithTemplate(String name, String key, String lead, String projectTemplateKey) {
        String s = (String)this.createResource().path("project/add").queryParam("name", new Object[]{name}).queryParam("key", new Object[]{key}).queryParam("lead", new Object[]{lead}).queryParam("template", new Object[]{projectTemplateKey}).request().get(String.class);
        return Long.parseLong(s);
    }

    public void deleteProject(String key) {
        this.createResource().path("project").path(key).request().delete(String.class);
    }

    public void setPermissionScheme(long projectId, long schemeId) {
        this.get(this.createResource().path("project/permissionScheme/set").queryParam("project", new Object[]{"" + projectId}).queryParam("scheme", new Object[]{"" + schemeId}));
    }

    public void setNotificationScheme(long projectId, Long schemeId) {
        WebTarget t = this.createResource().path("project/notificationScheme/set").queryParam("project", new Object[]{"" + projectId});
        if (schemeId != null) {
            t = t.queryParam("scheme", new Object[]{"" + schemeId});
        }
        this.get(t);
    }

    public void setIssueSecurityScheme(long projectId, Long schemeId) {
        WebTarget r = this.createResource().path("project/issueSecurityScheme/set").queryParam("project", new Object[]{"" + projectId});
        if (schemeId != null) {
            r = r.queryParam("scheme", new Object[]{"" + schemeId});
        }
        this.get(r);
    }

    public void addFieldConfigurationScheme(long projectId, long schemeId) {
        this.get(this.createResource().path("project/fieldConfigurationScheme/add").queryParam("project", new Object[]{"" + projectId}).queryParam("scheme", new Object[]{"" + schemeId}));
    }

    public void removeFieldConfigurationScheme(long projectId, long schemeId) {
        this.get(this.createResource().path("project/fieldConfigurationScheme/remove").queryParam("project", new Object[]{"" + projectId}).queryParam("scheme", new Object[]{"" + schemeId}));
    }

    public void setProjectCategory(long projectId, long projectCategoryId) {
        this.get(this.createResource().path("project/projectCategory/set").queryParam("project", new Object[]{"" + projectId}).queryParam("projectCategoryId", new Object[]{"" + projectCategoryId}));
    }

    public void setIssueTypeScreenScheme(long projectId, long issueTypeScreenSchemeId) {
        this.get(this.createResource().path("project/issueTypeScreenScheme/set").queryParam("project", new Object[]{"" + projectId}).queryParam("issueTypeScreenScheme", new Object[]{"" + issueTypeScreenSchemeId}));
    }

    public void setDefaultIssueType(long projectId, String issueTypeId) {
        WebTarget resource = this.createResource().path("project/defaultIssueType/set").queryParam("project", new Object[]{"" + projectId});
        if (issueTypeId != null) {
            resource = resource.queryParam("issueTypeId", new Object[]{"" + issueTypeId});
        }
        this.get(resource);
    }

    public void setProjectLead(long projectId, String username) {
        WebTarget resource = this.createResource().path("project/projectLead/set").queryParam("project", new Object[]{"" + projectId}).queryParam("username", new Object[]{"" + username});
        this.get(resource);
    }

    public void setProjectDefaultAssignee(long projectId, boolean setToProjectLead) {
        WebTarget resource = this.createResource().path("project/defaultAssignee/set").queryParam("project", new Object[]{"" + projectId}).queryParam("setToProjectLead", new Object[]{"" + setToProjectLead});
        this.get(resource);
    }

    public ProjectAssigneeType getProjectDefaultAssignee(String projectKey) {
        WebTarget resource = this.createResource().path("project").path(projectKey).path("defaultAssignee");
        return ProjectAssigneeType.withId(Integer.parseInt(this.get(resource)));
    }

    public ProjectSchemesBean getSchemes(Long projectId) {
        return this.getSchemes(Long.toString(projectId));
    }

    public ProjectSchemesBean getSchemes(String projectIdOrKey) {
        return (ProjectSchemesBean)this.createProjectSchemesResource(projectIdOrKey).request().get(ProjectSchemesBean.class);
    }

    public ProjectTypeKey getProjectType(Long projectId) {
        String type = (String)this.createResource().path("project").path(String.valueOf(projectId)).path("type").request().get(String.class);
        return new ProjectTypeKey(type);
    }

    public void updateProjectType(Long projectId, ProjectTypeKey newProjectType) {
        this.createResource().path("project").path(String.valueOf(projectId)).path("type").path(newProjectType.getKey()).request().put(null, String.class);
    }

    private WebTarget createProjectSchemesResource(String projectIdOrKey) {
        return this.createResource().path("project").path(projectIdOrKey).path("schemes");
    }

    public EntityList getEntityLinks(Long projectId) {
        return (EntityList)this.createResource().path("applinks").path("entitylinks").queryParam("projectId", new Object[]{Long.toString(projectId)}).request().get(EntityList.class);
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static enum ProjectAssigneeType {
        PROJECT_DEFAULT(0),
        COMPONENT_LEAD(1),
        PROJECT_LEAD(2),
        UNASSIGNED(3);

        private final int id;

        private ProjectAssigneeType(int id) {
            this.id = id;
        }

        static ProjectAssigneeType withId(int id) {
            for (ProjectAssigneeType type : ProjectAssigneeType.values()) {
                if (type.id != id) continue;
                return type;
            }
            throw new IllegalArgumentException(id + " is not a valid ProjectAssigneeType id.");
        }
    }
}

