/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client;

import com.atlassian.jira.testkit.beans.Resolution;
import com.atlassian.jira.testkit.client.BackdoorControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;

public class ResolutionControl
extends BackdoorControl<ResolutionControl> {
    private static final GenericType<List<Resolution>> LIST_GENERIC_TYPE = new GenericType<List<Resolution>>(){};

    public ResolutionControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public Resolution createResolution(String name, String description) {
        Resolution resolution = new Resolution();
        resolution.setName(name);
        resolution.setDescription(description);
        return (Resolution)this.createResolutionResource().request().post(Entity.json((Object)resolution), Resolution.class);
    }

    public Resolution updateResolution(long id, String name, String description) {
        Resolution resolution = new Resolution();
        resolution.setId(String.valueOf(id));
        resolution.setName(name);
        resolution.setDescription(description);
        return (Resolution)this.createResolutionResource().request().put(Entity.json((Object)resolution), Resolution.class);
    }

    public List<Resolution> getResolutions() {
        return (List)this.createResolutionResource().request().get(LIST_GENERIC_TYPE);
    }

    public void deleteResolution(long id) {
        this.createResolutionResource().path(String.valueOf(id)).request().delete();
    }

    public void setDefaultResolution(long id) {
        this.createResolutionResource().path(String.valueOf(id)).path("default").request().post(null);
    }

    public void moveResolutionUp(long id) {
        this.createResolutionResource().path(String.valueOf(id)).path("up").request().post(null);
    }

    public void moveResolutionDown(long id) {
        this.createResolutionResource().path(String.valueOf(id)).path("down").request().post(null);
    }

    private WebTarget createResolutionResource() {
        return this.createResource().path("resolution");
    }
}

