/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.dump.FuncTestTimer;
import com.atlassian.jira.testkit.client.dump.TestInformationKit;
import com.atlassian.jira.testkit.client.jerseyclient.ApacheClientFactoryImpl;
import com.atlassian.jira.testkit.client.restclient.Errors;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.logging.LoggingFeature;
import org.glassfish.jersey.media.multipart.internal.MultiPartWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RestApiClient<T extends RestApiClient<T>> {
    private static final Logger log = LoggerFactory.getLogger(RestApiClient.class);
    public static final String REST_VERSION = "2";
    private static ThreadLocal<Client> client = ThreadLocal.withInitial(() -> {
        ClientConfig config = new ClientConfig();
        config.property("jersey.config.client.suppressHttpComplianceValidation", (Object)true);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JodaModule());
        JacksonJaxbJsonProvider jacksonProvider = new JacksonJaxbJsonProvider();
        jacksonProvider.setMapper(objectMapper);
        jacksonProvider.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false);
        config.register((Object)jacksonProvider);
        config.register(MultiPartWriter.class);
        ApacheClientFactoryImpl clientFactory = new ApacheClientFactoryImpl(config);
        Client client = clientFactory.create();
        if (log.isDebugEnabled()) {
            client.register((Object)new LoggingFeature());
        }
        client.register(BackdoorLoggingFilter.class);
        client.register(JsonMediaTypeFilter.class);
        return client;
    });
    private final JIRAEnvironmentData environmentData;
    protected String loginAs;
    protected String loginPassword;
    private final Set<Response> responses;
    private String version;

    protected RestApiClient(JIRAEnvironmentData environmentData) {
        this(environmentData, REST_VERSION);
    }

    protected RestApiClient(JIRAEnvironmentData environmentData, String version) {
        this.loginPassword = this.loginAs = "admin";
        this.responses = Sets.newHashSet();
        this.environmentData = environmentData;
        this.version = version;
    }

    public T anonymous() {
        this.loginAs = null;
        this.loginPassword = null;
        return (T)this;
    }

    public T loginAs(String username) {
        return this.loginAs(username, username);
    }

    public T loginAs(String username, String password) {
        this.loginAs = username;
        this.loginPassword = password;
        return (T)this;
    }

    @Nonnull
    public JIRAEnvironmentData getEnvironmentData() {
        return this.environmentData;
    }

    protected WebTarget createResource() {
        return this.resourceRoot(this.environmentData.getBaseUrl().toExternalForm()).path("rest").path("api").path(this.version);
    }

    protected WebTarget createResource(Client client) {
        return this.resourceRoot(client, this.environmentData.getBaseUrl().toExternalForm()).path("rest").path("api").path(this.version);
    }

    protected WebTarget createResourceInternal() {
        return this.resourceRoot(this.environmentData.getBaseUrl().toExternalForm()).path("rest").path("internal").path("1.0");
    }

    protected WebTarget createResourceGadget() {
        return this.resourceRoot(this.environmentData.getBaseUrl().toExternalForm()).path("rest").path("gadget").path("1.0");
    }

    protected WebTarget resourceRoot(String url) {
        return this.resourceRoot(this.client(), url);
    }

    protected WebTarget resourceRoot(Client client, String url) {
        WebTarget target = client.target(url);
        if (this.loginAs != null) {
            target = target.queryParam("os_authType", new Object[]{"basic"}).queryParam("os_username", new Object[]{RestApiClient.percentEncode(this.loginAs)}).queryParam("os_password", new Object[]{RestApiClient.percentEncode(this.loginPassword)});
        }
        return target;
    }

    protected final Client client() {
        return client.get();
    }

    protected <T> ParsedResponse<T> toResponse(RestCall restCall) {
        Response clientResponse = this.registerResponse(restCall.call());
        if (clientResponse.getStatus() == 200) {
            ParsedResponse response = new ParsedResponse(clientResponse.getStatus(), null);
            clientResponse.close();
            return response;
        }
        return this.errorResponse(clientResponse);
    }

    protected <T> ParsedResponse<T> toResponse(RestCall restCall, Class<T> clazz) {
        return this.toResponse(restCall, new GenericType(clazz));
    }

    protected <T> ParsedResponse<T> toResponse(RestCall restCall, GenericType<T> clazz) {
        Response clientResponse = this.registerResponse(restCall.call());
        if (clientResponse.getStatus() < 300) {
            Object object = null;
            if (clientResponse.hasEntity()) {
                object = clientResponse.readEntity(clazz);
            }
            ParsedResponse<Object> tResponse = new ParsedResponse<Object>(clientResponse.getStatus(), null, object);
            clientResponse.close();
            return tResponse;
        }
        return this.errorResponse(clientResponse);
    }

    protected <T> ParsedResponse<T> errorResponse(Response clientResponse) {
        Errors entity = null;
        if (clientResponse.hasEntity() && MediaType.APPLICATION_JSON_TYPE.isCompatible(clientResponse.getMediaType())) {
            try {
                entity = (Errors)clientResponse.readEntity(Errors.class);
            }
            catch (Exception e) {
                log.debug("Failed to deserialise Errors from response", (Throwable)e);
            }
        }
        ParsedResponse response = new ParsedResponse(clientResponse.getStatus(), entity);
        clientResponse.close();
        return response;
    }

    protected WebTarget expanded(WebTarget resource, EnumSet<?> expands) {
        if (expands.isEmpty()) {
            return resource;
        }
        return resource.queryParam("expand", new Object[]{RestApiClient.percentEncode(StringUtils.join(expands, (String)","))});
    }

    protected Response registerResponse(Response response) {
        this.responses.add(response);
        return response;
    }

    public void cleanUp() {
        for (Response response : this.responses) {
            response.close();
        }
        this.responses.clear();
    }

    protected static <E extends Enum<E>> EnumSet<E> setOf(Class<E> cls, E ... expand) {
        return expand.length == 0 ? EnumSet.noneOf(cls) : EnumSet.of(expand[0], expand);
    }

    protected static String percentEncode(String queryParam) {
        return queryParam == null ? null : queryParam.replace("%", "%25");
    }

    @FunctionalInterface
    public static interface RestCall {
        public Response call();
    }

    public static class JsonMediaTypeFilter
    implements ClientRequestFilter {
        public void filter(ClientRequestContext requestContext) throws IOException {
            if (!requestContext.getHeaders().containsKey((Object)"Content-Type")) {
                requestContext.getHeaders().putSingle((Object)"Content-Type", (Object)"application/json");
            }
        }
    }

    public static class BackdoorLoggingFilter
    implements ClientRequestFilter,
    ClientResponseFilter {
        private void logRequest(ClientRequestContext request, int status, long howLong) {
            LoggerFactory.getLogger(RestApiClient.class).info(String.format("Backdoor %-6s in %5dms  %s %d", request.getMethod(), howLong, request.getUri().getPath(), status));
        }

        public void filter(ClientRequestContext requestContext) throws IOException {
            FuncTestTimer timer = TestInformationKit.pullTimer("Backdoor Shenanigans");
            requestContext.setProperty(FuncTestTimer.class.getCanonicalName(), (Object)timer);
        }

        public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
            FuncTestTimer timer = (FuncTestTimer)requestContext.getProperty(FuncTestTimer.class.getCanonicalName());
            this.logRequest(requestContext, responseContext.getStatus(), timer.end());
        }
    }
}

