/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client;

import com.atlassian.jira.testkit.beans.Screen;
import com.atlassian.jira.testkit.client.BackdoorControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import java.util.List;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;

public class ScreensControl
extends BackdoorControl<ScreensControl> {
    public ScreensControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public List<Screen> getAllScreens() {
        return (List)this.createResource().request().get((GenericType)new GenericType<List<Screen>>(){});
    }

    public Screen getScreen(String screenIdOrName) {
        return (Screen)this.createResource().queryParam("screen", new Object[]{screenIdOrName}).request().get(Screen.class);
    }

    public ScreensControl addTabToScreen(String screenName, String name) {
        this.get(this.createResource().path("addTab").queryParam("screen", new Object[]{"" + screenName}).queryParam("name", new Object[]{name}));
        return this;
    }

    public ParsedResponse<Screen.Tab> addTabToScreenResponse(String screenName, String name) {
        return this.toResponse(() -> (Response)this.createResource().path("addTab").queryParam("screen", new Object[]{"" + screenName}).queryParam("name", new Object[]{name}).request().get(Response.class), Screen.Tab.class);
    }

    public ScreensControl deleteTabFromScreen(String screenName, String name) {
        this.get(this.createResource().path("deleteTab").queryParam("screen", new Object[]{"" + screenName}).queryParam("name", new Object[]{name}));
        return this;
    }

    public ScreensControl addFieldToScreen(String screenName, String fieldName) {
        return this.addFieldToScreen(screenName, fieldName, null, null);
    }

    public ScreensControl addFieldToScreen(String screenName, String fieldName, String tabName, String position) {
        WebTarget query = this.createResource().path("addField").queryParam("screen", new Object[]{"" + screenName}).queryParam("field", new Object[]{fieldName});
        if (tabName != null) {
            query = query.queryParam("tab", new Object[]{tabName});
        }
        if (position != null) {
            query = query.queryParam("position", new Object[]{position});
        }
        this.get(query);
        return this;
    }

    public ScreensControl setFieldPosition(String screenName, String fieldName, int position) {
        this.get(this.createResource().path("setFieldPosition").queryParam("screen", new Object[]{"" + screenName}).queryParam("field", new Object[]{fieldName}).queryParam("position", new Object[]{String.valueOf(position)}));
        return this;
    }

    public ScreensControl removeFieldFromScreen(String screenName, String fieldName) {
        this.get(this.createResource().path("removeField").queryParam("screen", new Object[]{"" + screenName}).queryParam("field", new Object[]{fieldName}));
        return this;
    }

    @Override
    protected WebTarget createResource() {
        return super.createResource().path("screens");
    }
}

