/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client;

import com.atlassian.jira.testkit.client.BackdoorControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.GenericType;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class SearchRequestControl
extends BackdoorControl<SearchRequestControl> {
    private static final GenericType<List<SearchBean>> SEARCH_LIST_TYPE = new GenericType<List<SearchBean>>(){};

    public SearchRequestControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public String createFilter(String username, String searchJql, String searchName, String searchDescription) {
        return this.createFilter(username, searchJql, searchName, searchDescription, "");
    }

    public String createFilter(String username, String searchJql, String searchName, String searchDescription, String jsonShareString) {
        SearchBean searchBean = new SearchBean(username, searchJql, searchName, searchDescription, jsonShareString);
        return (String)this.createResource().path("filter").request().post(Entity.json((Object)searchBean), String.class);
    }

    public List<SearchBean> getOwnedFilters(String username) {
        return (List)this.createResource().path("filter").path("my").queryParam("username", new Object[]{username}).request().get(SEARCH_LIST_TYPE);
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class SearchBean {
        public String username;
        public String searchJql;
        public String searchName;
        public String searchDescription;
        public String jsonShareString;
        public boolean favourite;
        public long favouriteCount;

        public SearchBean() {
        }

        public SearchBean(String username, String searchJql, String searchName, String searchDescription, String jsonShareString) {
            this.username = username;
            this.searchJql = searchJql;
            this.searchName = searchName;
            this.searchDescription = searchDescription;
            this.jsonShareString = jsonShareString;
        }

        public String getUsername() {
            return this.username;
        }

        public SearchBean setUsername(String username) {
            this.username = username;
            return this;
        }

        public String getSearchJql() {
            return this.searchJql;
        }

        public SearchBean setSearchJql(String searchJql) {
            this.searchJql = searchJql;
            return this;
        }

        public String getSearchName() {
            return this.searchName;
        }

        public SearchBean setSearchName(String searchName) {
            this.searchName = searchName;
            return this;
        }

        public String getSearchDescription() {
            return this.searchDescription;
        }

        public SearchBean setSearchDescription(String searchDescription) {
            this.searchDescription = searchDescription;
            return this;
        }

        public String getJsonShareString() {
            return this.jsonShareString;
        }

        public SearchBean setJsonShareString(String jsonShareString) {
            this.jsonShareString = jsonShareString;
            return this;
        }

        public boolean isFavourite() {
            return this.favourite;
        }

        public SearchBean setFavourite(boolean favourite) {
            this.favourite = favourite;
            return this;
        }

        public long getFavouriteCount() {
            return this.favouriteCount;
        }

        public SearchBean setFavouriteCount(long favouriteCount) {
            this.favouriteCount = favouriteCount;
            return this;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

