/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client;

import com.atlassian.jira.testkit.client.BackdoorControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.GenericType;

public class ServicesControl
extends BackdoorControl<ServicesControl> {
    public ServicesControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public List<ServiceBean> getServices() {
        return (List)this.createResource().path("services").request().get((GenericType)new GenericType<List<ServiceBean>>(){});
    }

    public ServiceBean getService(long id) {
        return (ServiceBean)this.createResource().path("services/" + id).request().get(ServiceBean.class);
    }

    public void runService(long id) {
        this.createResource().path("services/" + id + "/run").request().post(null);
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ServiceBean {
        public Long id;
        public String name;
        public String serviceClass;
        public String cronExpression;
        public Long delay;
        public boolean local;
        public boolean usable;
        public Map<String, String> params;
    }
}

