/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client;

import com.atlassian.jira.testkit.beans.Status;
import com.atlassian.jira.testkit.client.BackdoorControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;

public class StatusControl
extends BackdoorControl<StatusControl> {
    private static final String DEFAULT_ICON = "/images/icons/statuses/generic.png";
    private static final GenericType<List<Status>> LIST_GENERIC_TYPE = new GenericType<List<Status>>(){};

    public StatusControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public Status createStatus(String name) {
        return this.createStatus(name, "");
    }

    public Status createStatus(String name, String description) {
        Status status = new Status();
        status.setName(name);
        status.setDescription(description);
        status.setIconUrl(DEFAULT_ICON);
        return (Status)this.createStatusResource().request().post(Entity.entity((Object)status, (MediaType)MediaType.APPLICATION_JSON_TYPE), Status.class);
    }

    public void editStatus(String id, String name, String description, String iconUrl) {
        Status status = new Status();
        status.setId(id);
        status.setName(name);
        status.setDescription(description);
        if (iconUrl == null) {
            status.setIconUrl(DEFAULT_ICON);
        } else {
            status.setIconUrl(iconUrl);
        }
        this.createStatusResource().request().put(Entity.entity((Object)status, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    public List<Status> getStatuses() {
        return (List)this.createStatusResource().request().get(LIST_GENERIC_TYPE);
    }

    public void deleteStatus(long id) {
        this.createStatusResource().path(String.valueOf(id)).request().delete();
    }

    private WebTarget createStatusResource() {
        return this.createResource().path("status");
    }
}

