/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client;

import com.atlassian.jira.testkit.client.BackdoorControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;

public class UserPreferencesControl
extends BackdoorControl<UserPreferencesControl> {
    private final String username;

    UserPreferencesControl(JIRAEnvironmentData environmentData, String username) {
        super(environmentData);
        this.username = username;
    }

    public UserPreferencesControl set(String name, String value) {
        return this.setPreference("string", name, value);
    }

    public UserPreferencesControl set(String name, Boolean value) {
        return this.setPreference("boolean", name, value);
    }

    public String getString(String name) {
        return (String)this.createResource().path(name).queryParam("type", new Object[]{"string"}).queryParam("username", new Object[]{this.username}).request().get(String.class);
    }

    public Long getLong(String name) {
        return (Long)this.createResource().path(name).queryParam("type", new Object[]{"long"}).queryParam("username", new Object[]{this.username}).request().get(Long.class);
    }

    public Boolean getBoolean(String name) {
        return (Boolean)this.createResource().path(name).queryParam("type", new Object[]{"boolean"}).queryParam("username", new Object[]{this.username}).request().get(Boolean.class);
    }

    public UserPreferencesControl set(String name, Long value) {
        return this.setPreference("long", name, value);
    }

    public UserPreferencesControl remove(String name) {
        this.createResource().path("preference").path(name).request().delete();
        return this;
    }

    @Override
    protected WebTarget createResource() {
        return super.createResource().path("userProfile").path("preference");
    }

    private UserPreferencesControl setPreference(String type, String name, Object value) {
        this.createResource().path(name).queryParam("username", new Object[]{this.username}).queryParam("type", new Object[]{type}).request(new MediaType[]{MediaType.TEXT_PLAIN_TYPE}).put(Entity.text((Object)value.toString()));
        return this;
    }
}

