/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client;

import com.atlassian.jira.testkit.beans.DirectoryDTO;
import com.atlassian.jira.testkit.beans.LoginInfoBean;
import com.atlassian.jira.testkit.beans.UserDTO;
import com.atlassian.jira.testkit.client.BackdoorControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;

public class UsersAndGroupsControl
extends BackdoorControl<UsersAndGroupsControl> {
    public UsersAndGroupsControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public UsersAndGroupsControl addUser(String username) {
        this.addUser(username, username, username, username + "@example.com");
        return this;
    }

    public UsersAndGroupsControl addUser(String username, String password, String displayName, String email) {
        this.addUser(username, password, displayName, email, false);
        return this;
    }

    public UsersAndGroupsControl addUser(String username, String password, String displayName, String email, boolean sendEmail) {
        this.get(this.createResource().path("user").path("add").queryParam("userName", new Object[]{username}).queryParam("password", new Object[]{password}).queryParam("displayName", new Object[]{displayName}).queryParam("email", new Object[]{email}).queryParam("sendEmail", new Object[]{"" + sendEmail}));
        return this;
    }

    public UsersAndGroupsControl addUserEvenIfUserExists(String username) {
        this.addUserEvenIfUserExists(username, username, username, username + "@example.com");
        return this;
    }

    public UsersAndGroupsControl addUserEvenIfUserExists(String username, String password, String displayName, String email) {
        this.addUserEvenIfUserExists(username, password, displayName, email, false);
        return this;
    }

    public UsersAndGroupsControl addUserEvenIfUserExists(String username, String password, String displayName, String email, boolean sendEmail) {
        this.get(this.createResource().path("user").path("addEvenIfUserExists").queryParam("userName", new Object[]{username}).queryParam("password", new Object[]{password}).queryParam("displayName", new Object[]{displayName}).queryParam("email", new Object[]{email}).queryParam("sendEmail", new Object[]{"" + sendEmail}));
        return this;
    }

    public UsersAndGroupsControl addUsers(String usernamePrefix, String displayNamePrefix, int numberOfNewUsers) {
        this.get(this.createResource().path("user").path("addMany").queryParam("usernamePrefix", new Object[]{usernamePrefix}).queryParam("displayNamePrefix", new Object[]{displayNamePrefix}).queryParam("numberOfNewUsers", new Object[]{"" + numberOfNewUsers}));
        return this;
    }

    public void addUsersWithGroup(String usernamePrefix, String displayNamePrefix, int numberOfNewUsers, String groupName) {
        this.get(this.createResource().path("user").path("addMany").queryParam("usernamePrefix", new Object[]{usernamePrefix}).queryParam("displayNamePrefix", new Object[]{displayNamePrefix}).queryParam("numberOfNewUsers", new Object[]{"" + numberOfNewUsers}).queryParam("groupName", new Object[]{groupName}));
    }

    public void deleteUser(String username) {
        this.get(this.createResource().path("user").path("delete").queryParam("userName", new Object[]{username}));
    }

    public boolean userExists(String username) {
        return (Boolean)this.createResource().path("user").path("exists").queryParam("userName", new Object[]{username}).request().get(Boolean.class);
    }

    public boolean isUserInGroup(String username, String groupName) {
        return (Boolean)this.createResource().path("group").path("includes").queryParam("userName", new Object[]{username}).queryParam("groupName", new Object[]{groupName}).request().get(Boolean.class);
    }

    public boolean isGroupInGroup(String childGroupName, String parentGroupName) {
        return (Boolean)this.createResource().path("group").path("includesGroup").queryParam("groupName", new Object[]{childGroupName}).queryParam("parentGroupName", new Object[]{parentGroupName}).request().get(Boolean.class);
    }

    public void addUserToGroup(String username, String groupName) {
        this.get(this.createResource().path("user").path("addToGroup").queryParam("userName", new Object[]{username}).queryParam("groupName", new Object[]{groupName}));
    }

    public void removeUserFromGroup(String username, String groupName) {
        this.get(this.createResource().path("user").path("removeFromGroup").queryParam("userName", new Object[]{username}).queryParam("groupName", new Object[]{groupName}));
    }

    public void addGroup(String groupName) {
        this.get(this.createResource().path("group").path("add").queryParam("groupName", new Object[]{groupName}));
    }

    public boolean groupExists(String groupName) {
        return Boolean.parseBoolean(this.get(this.createResource().path("group").path("exists").queryParam("groupName", new Object[]{groupName})));
    }

    public UsersAndGroupsControl deleteGroup(String groupName) {
        this.get(this.createResource().path("group").path("delete").queryParam("groupName", new Object[]{groupName}));
        return this;
    }

    public void addGroupToGroup(String childGroupName, String parentGroupName) {
        this.get(this.createResource().path("group").path("addToGroup").queryParam("groupName", new Object[]{childGroupName}).queryParam("parentGroupName", new Object[]{parentGroupName}));
    }

    public UsersAndGroupsControl addGroups(String groupNamePrefix, int numberOfNewGroups, @Nullable String parentGroupName, int numberOfNewUsersPerGroup) {
        this.get(this.createResource().path("group").path("addMany").queryParam("groupNamePrefix", new Object[]{groupNamePrefix}).queryParam("numberOfNewGroups", new Object[]{"" + numberOfNewGroups}).queryParam("parentGroupName", new Object[]{parentGroupName}).queryParam("numberOfNewUsersPerGroup", new Object[]{"" + numberOfNewUsersPerGroup}));
        return this;
    }

    public UsersAndGroupsControl resetLoginCount(String username) {
        this.get(this.createResource().path("user").path("resetLoginCount").queryParam("user", new Object[]{username}));
        return this;
    }

    public long getNumberOfUsers() {
        return Long.parseLong((String)this.createResource().path("user").path("count").request().get(String.class));
    }

    public long getNumberOfGroups() {
        return Long.parseLong((String)this.createResource().path("group").path("count").request().get(String.class));
    }

    public LoginInfoBean getLoginInfo(String username) {
        return (LoginInfoBean)this.createResource().path("user").path("loginInfo").queryParam("userName", new Object[]{username}).request().get(LoginInfoBean.class);
    }

    public List<UserDTO> getAllUsers() {
        return Arrays.asList((Object[])this.createResource().path("user").path("all").request().get(UserDTO[].class));
    }

    public UserDTO getUserByName(String username) {
        return (UserDTO)this.createResource().path("user").path("byName").queryParam("userName", new Object[]{username}).request().get(UserDTO.class);
    }

    public UserDTO getUserByNameEvenWhenUnknown(String username) {
        return (UserDTO)this.createResource().path("user").path("byNameEvenWhenUnknown").queryParam("userName", new Object[]{username}).request().get(UserDTO.class);
    }

    public void updateUser(UserDTO user) {
        this.createResource().path("user").path("byName").request().post(Entity.json((Object)user));
    }

    public List<DirectoryDTO> getAllDirectories() {
        return Arrays.asList((Object[])this.createResource().path("directory").request().get(DirectoryDTO[].class));
    }

    public DirectoryDTO getDirectory(long id) {
        return (DirectoryDTO)this.createResource().path("directory").path(String.valueOf(id)).request().get(DirectoryDTO.class);
    }

    @Override
    protected WebTarget createResource() {
        return super.createResource().path("usersAndGroups");
    }
}

