/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client;

import com.atlassian.jira.testkit.beans.WorkflowSchemeData;
import com.atlassian.jira.testkit.client.BackdoorControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import java.util.List;
import java.util.function.Supplier;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;

public class WorkflowSchemesControl
extends BackdoorControl<WorkflowSchemesControl> {
    private static final GenericType<List<WorkflowSchemeData>> LIST_GENERIC_TYPE = new GenericType<List<WorkflowSchemeData>>(){};

    public WorkflowSchemesControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public WorkflowSchemeData getWorkflowSchemeByProjectKey(String projectKey) {
        WebTarget workflowSchemeResource = this.createWorkflowSchemeResource();
        return (WorkflowSchemeData)workflowSchemeResource.queryParam("projectKey", new Object[]{projectKey}).request().get(WorkflowSchemeData.class);
    }

    public WorkflowSchemeData getWorkflowSchemeByProjectName(String projectName) {
        WebTarget workflowSchemeResource = this.createWorkflowSchemeResource();
        return (WorkflowSchemeData)workflowSchemeResource.queryParam("projectName", new Object[]{projectName}).request().get(WorkflowSchemeData.class);
    }

    public WorkflowSchemeData getWorkflowSchemeByName(String schemeName) {
        WebTarget workflowSchemeResource = this.createWorkflowSchemeResource();
        return (WorkflowSchemeData)workflowSchemeResource.queryParam("schemeName", new Object[]{schemeName}).request().get(WorkflowSchemeData.class);
    }

    public WorkflowSchemeData getWorkflowSchemeByNameNullIfNotFound(String schemeName) {
        return this.nullIfNotFound(() -> this.getWorkflowSchemeByName(schemeName));
    }

    public WorkflowSchemeData getWorkflowSchemeDraftByProjectNameNullIfNotFound(String projectName) {
        return this.nullIfNotFound(() -> this.getWorkflowSchemeDraftByProjectName(projectName));
    }

    public WorkflowSchemeData getWorkflowSchemeDraftByProjectName(String projectName) {
        WebTarget workflowSchemeResource = this.createWorkflowSchemeResource();
        return (WorkflowSchemeData)workflowSchemeResource.queryParam("projectName", new Object[]{projectName}).queryParam("draft", new Object[]{"true"}).request().get(WorkflowSchemeData.class);
    }

    public WorkflowSchemeData getWorkflowSchemeDraftByProjectKey(String projectKey) {
        WebTarget workflowSchemeResource = this.createWorkflowSchemeResource();
        return (WorkflowSchemeData)workflowSchemeResource.queryParam("projectKey", new Object[]{projectKey}).queryParam("draft", new Object[]{"true"}).request().get(WorkflowSchemeData.class);
    }

    public List<WorkflowSchemeData> getWorkflowSchemes() {
        return (List)this.createWorkflowSchemeResource().request().get(LIST_GENERIC_TYPE);
    }

    public WorkflowSchemeData getWorkflowScheme(long id) {
        return (WorkflowSchemeData)this.createWorkflowSchemeResource(id).request().get(WorkflowSchemeData.class);
    }

    public WorkflowSchemeData getWorkflowSchemeForParent(long id) {
        return (WorkflowSchemeData)this.createDraftWorkflowSchemeResource(id).request().get(WorkflowSchemeData.class);
    }

    public WorkflowSchemeData getWorkflowSchemeForParentNullIfNotFound(long id) {
        return this.nullIfNotFound(() -> this.getWorkflowSchemeForParent(id));
    }

    public WorkflowSchemeData createDraft(WorkflowSchemeData scheme) {
        WebTarget workflowSchemeResource = this.createWorkflowSchemeResource(scheme.getId());
        return (WorkflowSchemeData)workflowSchemeResource.path("draft").request().put(Entity.json((Object)scheme.getId()), WorkflowSchemeData.class);
    }

    public WorkflowSchemeData createScheme(WorkflowSchemeData scheme) {
        WebTarget workflowSchemeResource = this.createWorkflowSchemeResource();
        return (WorkflowSchemeData)workflowSchemeResource.request().put(Entity.json((Object)scheme), WorkflowSchemeData.class);
    }

    public WorkflowSchemeData updateScheme(WorkflowSchemeData scheme) {
        WebTarget workflowSchemeResource = this.createWorkflowSchemeResource(scheme.getId());
        return (WorkflowSchemeData)workflowSchemeResource.request().put(Entity.json((Object)scheme), WorkflowSchemeData.class);
    }

    public void deleteScheme(long id) {
        WebTarget workflowSchemeResource = this.createWorkflowSchemeResource(id);
        workflowSchemeResource.request().delete(String.class);
    }

    public WorkflowSchemeData createDraftScheme(long parentId) {
        WebTarget workflowSchemeResource = this.createDraftWorkflowSchemeResource(parentId);
        return (WorkflowSchemeData)workflowSchemeResource.request().put(Entity.json((Object)parentId), WorkflowSchemeData.class);
    }

    public WorkflowSchemeData updateDraftScheme(long parentId, WorkflowSchemeData data) {
        WebTarget workflowSchemeResource = this.createDraftWorkflowSchemeResource(parentId);
        return (WorkflowSchemeData)workflowSchemeResource.request().post(Entity.json((Object)data), WorkflowSchemeData.class);
    }

    public void discardDraftScheme(long parentId) {
        WebTarget workflowSchemeResource = this.createDraftWorkflowSchemeResource(parentId);
        workflowSchemeResource.request().delete(String.class);
    }

    public Long copyScheme(String schemeName, String newSchemeName) {
        return Long.parseLong((String)this.createWorkflowSchemeResource().path("copy").queryParam("schemeName", new Object[]{schemeName}).queryParam("newSchemeName", new Object[]{newSchemeName}).request().get(String.class));
    }

    public void assignScheme(long schemeId, String issueType, String workflowName) {
        WorkflowSchemeData scheme = this.getWorkflowScheme(schemeId).setMapping(issueType, workflowName);
        this.updateScheme(scheme);
    }

    private WebTarget createWorkflowSchemeResource(long id) {
        return this.createWorkflowSchemeResource().path(String.valueOf(id));
    }

    private WebTarget createDraftWorkflowSchemeResource(long id) {
        return this.createWorkflowSchemeResource(id).path("draft");
    }

    private WebTarget createWorkflowSchemeResource() {
        return this.createResource().path("workflowscheme");
    }

    private WorkflowSchemeData nullIfNotFound(Supplier<WorkflowSchemeData> supplier) {
        try {
            return supplier.get();
        }
        catch (WebApplicationException e) {
            if (Response.Status.NOT_FOUND.getStatusCode() == e.getResponse().getStatus()) {
                return null;
            }
            throw e;
        }
    }
}

