/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.AnalyticsEnabled;
import com.atlassian.jira.testkit.client.restclient.AnalyticsReportConfig;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class AnalyticsClient
extends RestApiClient<AnalyticsClient> {
    public AnalyticsClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public void acknowledgePolicy() {
        this.toResponse(() -> (Response)this.createResource().path("config").path("acknowledge").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(null, Response.class));
    }

    public void disable() {
        this.toResponse(() -> (Response)this.createResource().path("config").path("enable").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)new AnalyticsEnabled(false)), Response.class));
    }

    public void enable() {
        this.toResponse(() -> (Response)this.createResource().path("config").path("enable").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)new AnalyticsEnabled(true)), Response.class));
    }

    public void startCapturing() {
        this.toResponse(() -> (Response)this.createResource().path("report").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)new AnalyticsReportConfig(true)), Response.class));
    }

    public void stopCapturing() {
        this.toResponse(() -> (Response)this.createResource().path("report").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)new AnalyticsReportConfig(false)), Response.class));
    }

    public void clearCaptured() {
        this.toResponse(() -> (Response)this.createResource().path("report").request().delete(Response.class));
    }

    public ParsedResponse getReport(ReportMode reportMode) {
        return this.toResponse(() -> (Response)this.createResource().path("report").queryParam("mode", new Object[]{reportMode.alias}).request().get(Response.class));
    }

    @Override
    protected WebTarget createResource() {
        return this.resourceRoot(this.getEnvironmentData().getBaseUrl().toExternalForm()).path("rest").path("analytics").path("1.0");
    }

    public static enum ReportMode {
        BTF("btf_processed"),
        CLOUD("ondemand_processed"),
        RAW("unprocessed");

        final String alias;

        private ReportMode(String alias) {
            this.alias = alias;
        }
    }
}

