/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.Comment;
import com.atlassian.jira.testkit.client.restclient.CommentsWithPaginationBean;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import java.util.Objects;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class CommentClient
extends RestApiClient<CommentClient> {
    public CommentClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public ParsedResponse<Comment> get(String issueKey, String commentID) throws WebApplicationException {
        return this.toResponse(() -> (Response)this.commentWithID(issueKey, commentID).request().get(Response.class), Comment.class);
    }

    public ParsedResponse<Comment> get(String issueKey, String commentID, String expand) throws WebApplicationException {
        return this.toResponse(() -> (Response)this.commentWithID(issueKey, commentID).queryParam("expand", new Object[]{expand}).request().get(Response.class), Comment.class);
    }

    public ParsedResponse<CommentsWithPaginationBean> getComments(String issueKey) {
        return this.toResponse(() -> (Response)this.createResource().path("issue").path(issueKey).path("comment").request().get(Response.class), CommentsWithPaginationBean.class);
    }

    public ParsedResponse<CommentsWithPaginationBean> getComments(String issueKey, Integer startAt, Integer maxResults, String orderBy) {
        return this.toResponse(() -> (Response)this.createResource().path("issue").path(issueKey).path("comment").queryParam("startAt", new Object[]{Objects.toString(startAt)}).queryParam("maxResults", new Object[]{Objects.toString(maxResults)}).queryParam("orderBy", new Object[]{orderBy}).request().get(Response.class), CommentsWithPaginationBean.class);
    }

    public ParsedResponse<CommentsWithPaginationBean> getComments(String issueKey, String expand) {
        return this.toResponse(() -> (Response)this.createResource().path("issue").path(issueKey).path("comment").queryParam("expand", new Object[]{expand}).request().get(Response.class), CommentsWithPaginationBean.class);
    }

    public ParsedResponse<Comment> put(String issueKey, Comment comment) {
        return this.toResponse(() -> (Response)this.createResource().path("issue").path(issueKey).path("comment").path(comment.id).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)comment), Response.class), Comment.class);
    }

    public ParsedResponse<Comment> put(String issueKey, Comment comment, String expand) {
        return this.toResponse(() -> (Response)this.createResource().path("issue").path(issueKey).path("comment").path(comment.id).queryParam("expand", new Object[]{expand}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)comment), Response.class), Comment.class);
    }

    public ParsedResponse<Comment> post(String issueKey, Comment comment) {
        return this.toResponse(() -> (Response)this.createResource().path("issue").path(issueKey).path("comment").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)comment), Response.class), Comment.class);
    }

    public ParsedResponse<Comment> post(String issueKey, Comment comment, String expand) {
        return this.toResponse(() -> (Response)this.createResource().path("issue").path(issueKey).path("comment").queryParam("expand", new Object[]{expand}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)comment), Response.class), Comment.class);
    }

    public ParsedResponse delete(String issueKey, Comment comment) {
        return this.delete(issueKey, comment.id);
    }

    public ParsedResponse delete(String issueKey, String commentId) {
        return this.toResponse(() -> (Response)this.createResource().path("issue").path(issueKey).path("comment").path(commentId).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).delete(Response.class));
    }

    public ParsedResponse getResponse(String issueKey, String commentID) {
        return this.toResponse(() -> (Response)this.commentWithID(issueKey, commentID).request().get(Response.class));
    }

    protected WebTarget commentWithID(String issueKey, String commentID) {
        return this.createResource().path("issue").path(issueKey).path("comment").path(commentID);
    }
}

