/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.Component;
import com.atlassian.jira.testkit.client.restclient.ComponentIssueCounts;
import com.atlassian.jira.testkit.client.restclient.PageBean;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import java.net.URI;
import java.util.Set;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class ComponentClient
extends RestApiClient<ComponentClient> {
    public ComponentClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public Component get(String componentID) throws WebApplicationException {
        return (Component)this.componentWithId(componentID).request().get(Component.class);
    }

    public ParsedResponse getResponse(String componentID) {
        return this.toResponse(() -> (Response)this.componentWithId(componentID).request().get(Response.class));
    }

    protected WebTarget componentWithId(String componentID) {
        return this.createResource().path("component").path(componentID);
    }

    public Component create(Component component) {
        try {
            return (Component)this.component().post(Entity.json((Object)component), Component.class);
        }
        catch (WebApplicationException e) {
            throw new RuntimeException("Failed to create component: " + this.errorResponse(e.getResponse()), e);
        }
    }

    public ParsedResponse createResponse(Component component) {
        return this.toResponse(() -> (Response)this.component().post(Entity.json((Object)component), Response.class));
    }

    public ParsedResponse putResponse(String componentId, Component component) {
        return this.toResponse(() -> (Response)this.componentWithId(componentId).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)component), Response.class));
    }

    public ParsedResponse putResponse(Component component) {
        String[] selfParts = component.self.split("/");
        String componentId = selfParts[selfParts.length - 1];
        return this.putResponse(componentId, component);
    }

    public ComponentIssueCounts getComponentIssueCounts(String componentId) throws WebApplicationException {
        return (ComponentIssueCounts)this.componentWithId(componentId).path("relatedIssueCounts").request().get(ComponentIssueCounts.class);
    }

    public ParsedResponse getComponentIssueCountsResponse(String componentId) {
        return this.toResponse(() -> (Response)this.componentWithId(componentId).path("relatedIssueCounts").request().get(Response.class));
    }

    public ParsedResponse delete(String componentId) throws WebApplicationException {
        return this.delete(componentId, null);
    }

    public ParsedResponse delete(String componentId, URI swapComponent) throws WebApplicationException {
        return this.toResponse(() -> {
            WebTarget deleteResource = this.componentWithId(componentId);
            if (swapComponent != null) {
                deleteResource = deleteResource.queryParam("moveIssuesTo", new Object[]{swapComponent.getPath()});
            }
            return (Response)deleteResource.request().delete(Response.class);
        });
    }

    public PageBean<Component> getPage(Long startAt, Integer maxResults, String query, Set<String> projectIds) {
        WebTarget webTarget = this.createResource().path("component").path("page").queryParam("startAt", new Object[]{startAt.toString()}).queryParam("maxResults", new Object[]{maxResults.toString()}).queryParam("query", new Object[]{query});
        for (String projectId : projectIds) {
            webTarget = webTarget.queryParam("projectIds", new Object[]{projectId});
        }
        return (PageBean)webTarget.request().get((GenericType)new GenericType<PageBean<Component>>(){});
    }

    private Invocation.Builder component() {
        return this.createResource().path("component").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
    }
}

