/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.atlassian.jira.rest.api.dashboard.DashboardBean;
import com.atlassian.jira.rest.api.dashboard.DashboardsBean;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import javax.annotation.Nullable;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;

public class DashboardClient
extends RestApiClient<DashboardClient> {
    public DashboardClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public DashboardClient(JIRAEnvironmentData environmentData, String version) {
        super(environmentData, version);
    }

    public DashboardBean getSingle(String dashboardId) {
        try {
            return (DashboardBean)this.createResource().path("dashboard").path(dashboardId).request().get(DashboardBean.class);
        }
        catch (WebApplicationException e) {
            throw new RuntimeException("Failed to get list of dashboards: " + this.errorResponse(e.getResponse()), e);
        }
    }

    public ParsedResponse getSingleResponse(String dashboardId) {
        return this.toResponse(() -> (Response)this.createResource().path("dashboard").path(dashboardId).request().get(Response.class));
    }

    public DashboardsBean getList(@Nullable String filter, @Nullable Integer startAt, @Nullable Integer maxResults) {
        try {
            WebTarget resource = this.createResource(filter, startAt, maxResults);
            return (DashboardsBean)resource.request().get(DashboardsBean.class);
        }
        catch (WebApplicationException e) {
            throw new RuntimeException("Failed to get list of dashboards: " + this.errorResponse(e.getResponse()), e);
        }
    }

    public ParsedResponse getListResponse(String filter, Integer startAt, Integer maxResults) {
        return this.toResponse(() -> (Response)this.createResource(filter, startAt, maxResults).request().get(Response.class));
    }

    private WebTarget createResource(String filter, Integer startAt, Integer maxResults) {
        WebTarget resource = this.createResource().path("dashboard");
        if (filter != null) {
            resource = resource.queryParam("filter", new Object[]{filter});
        }
        if (startAt != null) {
            resource = resource.queryParam("startAt", new Object[]{String.valueOf(startAt)});
        }
        if (maxResults != null) {
            resource = resource.queryParam("maxResults", new Object[]{String.valueOf(maxResults)});
        }
        return resource;
    }
}

