/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class DeleteVersionWithCustomFieldParameters {
    private Long moveFixIssuesTo;
    private Long moveAffectedIssuesTo;
    private List<CustomFieldReplacement> customFieldReplacementList;

    public DeleteVersionWithCustomFieldParameters(@Nullable Long moveFixIssuesTo, @Nullable Long moveAffectedIssuesTo, @Nullable List<CustomFieldReplacement> customFieldReplacementList) {
        this.moveFixIssuesTo = moveFixIssuesTo;
        this.moveAffectedIssuesTo = moveAffectedIssuesTo;
        this.customFieldReplacementList = customFieldReplacementList;
    }

    public Long getMoveFixIssuesTo() {
        return this.moveFixIssuesTo;
    }

    public Long getMoveAffectedIssuesTo() {
        return this.moveAffectedIssuesTo;
    }

    public List<CustomFieldReplacement> getCustomFieldReplacementList() {
        return this.customFieldReplacementList;
    }

    public static Builder create() {
        return new Builder();
    }

    public static class Builder {
        private Long moveFixedIssuesTo;
        private Long moveAffectedIssuesTo;
        private List<CustomFieldReplacement> customFieldReplacementList;

        public Builder moveFixIssuesTo(long moveFixIssuesTo) {
            this.moveFixedIssuesTo = moveFixIssuesTo;
            return this;
        }

        public Builder moveAffectedIssuesTo(long moveAffectedIssuesTo) {
            this.moveAffectedIssuesTo = moveAffectedIssuesTo;
            return this;
        }

        public Builder moveCustomFieldTo(long customFieldId, long moveCustomFieldTo) {
            this.customFieldsReplacements().add(new CustomFieldReplacement(customFieldId, moveCustomFieldTo));
            return this;
        }

        public Builder deleteCustomField(long customFieldId, long moveCustomFieldTo) {
            this.customFieldsReplacements().add(new CustomFieldReplacement(customFieldId, null));
            return this;
        }

        public DeleteVersionWithCustomFieldParameters build() {
            return new DeleteVersionWithCustomFieldParameters(this.moveFixedIssuesTo, this.moveAffectedIssuesTo, this.customFieldReplacementList);
        }

        private List<CustomFieldReplacement> customFieldsReplacements() {
            if (this.customFieldReplacementList == null) {
                this.customFieldReplacementList = Lists.newArrayList();
            }
            return this.customFieldReplacementList;
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CustomFieldReplacement {
        Long customFieldId;
        Long moveTo;

        public CustomFieldReplacement(@Nullable Long customFieldId, @Nullable Long moveTo) {
            this.customFieldId = customFieldId;
            this.moveTo = moveTo;
        }

        public Long getCustomFieldId() {
            return this.customFieldId;
        }

        public Long getMoveTo() {
            return this.moveTo;
        }
    }
}

