/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.EntityProperty;
import com.atlassian.jira.testkit.client.restclient.EntityPropertyKeys;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.util.json.JSONObject;
import io.atlassian.fugue.Option;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;

public class EntityPropertyClient
extends RestApiClient<EntityPropertyClient> {
    protected final String entityName;

    public EntityPropertyClient(JIRAEnvironmentData environmentData, String entityName) {
        super(environmentData);
        this.entityName = entityName;
    }

    public EntityPropertyKeys getKeys(String entityKeyOrId) {
        return (EntityPropertyKeys)this.resource(entityKeyOrId).request().get(EntityPropertyKeys.class);
    }

    public EntityProperty get(String entitykeyOrId, String propertyKey) {
        return (EntityProperty)this.resource(entitykeyOrId, propertyKey).request().get(EntityProperty.class);
    }

    public ParsedResponse<String> put(String entityKeyOrId, String propertyKey, JSONObject value) {
        return this.toResponse(() -> this.resource(entityKeyOrId, propertyKey).request(new String[]{"application/json"}).put(Entity.json((Object)value.toString())), String.class);
    }

    public ParsedResponse delete(String entityKeyOrId, String propertyKey) {
        return this.toResponse(() -> this.resource(entityKeyOrId, propertyKey).request().delete());
    }

    public WebTarget resource(String entityKeyOrId) {
        return this.resource((Option<String>)Option.some((Object)entityKeyOrId), (Option<String>)Option.none());
    }

    public WebTarget resource(String entityKeyOrId, String propertyKey) {
        return this.resource((Option<String>)Option.some((Object)entityKeyOrId), (Option<String>)Option.some((Object)propertyKey));
    }

    protected WebTarget resource(Option<String> entityKeyOrId, Option<String> propertyKey) {
        WebTarget webTarget = this.createResource().path(this.entityName);
        webTarget = "user".equals(this.entityName) ? webTarget.queryParam("username", new Object[]{entityKeyOrId.getOrElse((Object)"")}) : webTarget.path((String)entityKeyOrId.getOrElse((Object)""));
        return webTarget.path("properties").path((String)propertyKey.getOrElse((Object)""));
    }
}

