/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.atlassian.jira.testkit.client.restclient.Expando;
import com.atlassian.jira.testkit.client.restclient.Group;
import com.atlassian.jira.testkit.client.restclient.Project;
import com.atlassian.jira.testkit.client.restclient.ProjectRole;
import com.atlassian.jira.testkit.client.restclient.User;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Objects;
import javax.ws.rs.core.GenericType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Filter {
    public static final GenericType<List<Filter>> FILTER_TYPE = new GenericType<List<Filter>>(){};
    public String self;
    public String id;
    public String name;
    public String description;
    public User owner;
    public String jql;
    public String viewUrl;
    public String searchUrl;
    public boolean favourite;
    public List<FilterPermission> sharePermissions;
    public Expando<User> sharedUsers;
    public Expando<FilterSubscription> subscriptions;
    public boolean editable;

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class FilterSubscription {
        public Long id;
        public User user;
        public Group group;
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class FilterPermission {
        public Long id;
        public String type;
        public Project project;
        public ProjectRole role;
        public User user;
        public Group group;
        public boolean view;
        public boolean edit;

        public FilterPermission id(Long id) {
            this.id = id;
            return this;
        }

        public FilterPermission type(String type) {
            this.type = type;
            return this;
        }

        public FilterPermission project(Project project) {
            this.project = project;
            return this;
        }

        public FilterPermission role(ProjectRole role) {
            this.role = role;
            return this;
        }

        public FilterPermission group(Group group) {
            this.group = group;
            return this;
        }

        public FilterPermission user(User user) {
            this.user = user;
            return this;
        }

        public FilterPermission view(boolean view) {
            this.view = view;
            return this;
        }

        public FilterPermission edit(boolean edit) {
            this.edit = edit;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FilterPermission that = (FilterPermission)o;
            if (this.group != null ? !this.group.equals((Object)that.group) : that.group != null) {
                return false;
            }
            if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
                return false;
            }
            if (this.project != null ? !this.project.equals(that.project) : that.project != null) {
                return false;
            }
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) {
                return false;
            }
            if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
                return false;
            }
            if (this.user != null ? !this.user.equals(that.user) : that.user != null) {
                return false;
            }
            if (this.view != that.view) {
                return false;
            }
            return this.view == that.view;
        }

        public int hashCode() {
            return Objects.hash(this.id, this.type, this.project, this.role, this.user, this.group, this.view, this.edit);
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static enum Expand {
        subscriptions,
        sharedUsers;

    }
}

