/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.Filter;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

public class FilterClient
extends RestApiClient<FilterClient> {
    public FilterClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public Filter get(String filterId, Filter.Expand ... expand) throws WebApplicationException {
        return (Filter)this.filterWithId(filterId, expand).request().get(Filter.class);
    }

    public List<Filter> getFavouriteFilters(Filter.Expand ... expand) {
        return (List)this.addExpands(this.createResource().path("filter").path("favourite"), expand).request().get(Filter.FILTER_TYPE);
    }

    public ParsedResponse getResponse(String filterId) {
        return this.toResponse(() -> (Response)this.filterWithId(filterId, new Filter.Expand[0]).request().get(Response.class));
    }

    private WebTarget filterTarget() {
        return this.createResource().path("filter");
    }

    private WebTarget addExpands(WebTarget resource, Filter.Expand ... expand) {
        EnumSet expands = FilterClient.setOf(Filter.Expand.class, (Enum[])expand);
        if (expands.isEmpty()) {
            return resource;
        }
        return resource.queryParam("expand", new Object[]{FilterClient.percentEncode(StringUtils.join((Collection)expands, (String)","))});
    }

    protected WebTarget filterWithId(String filterId, Filter.Expand ... expand) {
        return this.addExpands(this.createResource().path("filter").path(filterId), expand);
    }

    public ParsedResponse<Filter> postFilterResponse(Filter filter, Filter.Expand ... expand) {
        return this.toResponse(() -> (Response)this.filterResourceForPost(expand).post(Entity.json((Object)filter), Response.class), Filter.class);
    }

    public ParsedResponse<Filter> putFilterResponse(Filter filter, Filter.Expand ... expand) {
        return this.toResponse(() -> (Response)this.filterResourceForPut(filter.id, expand).put(Entity.json((Object)filter), Response.class), Filter.class);
    }

    public ParsedResponse<List<Filter.FilterPermission>> getFilterPermissions(String filterId) {
        return this.toResponse(() -> (Response)this.filterWithId(filterId, new Filter.Expand[0]).path("permission").request().get(Response.class), new GenericType<List<Filter.FilterPermission>>(){});
    }

    public ParsedResponse<Filter.FilterPermission> getFilterPermission(String filterId, String filterPermissionId) {
        return this.toResponse(() -> (Response)this.filterWithId(filterId, new Filter.Expand[0]).path("permission").path(filterPermissionId).request().get(Response.class), Filter.FilterPermission.class);
    }

    public ParsedResponse deleteFilterPermission(String filterId, String filterPermissionId) {
        return this.toResponse(() -> (Response)this.filterWithId(filterId, new Filter.Expand[0]).path("permission").path(filterPermissionId).request().delete(Response.class));
    }

    public ParsedResponse<List<Filter.FilterPermission>> postFilterPermission(String filterId, FilterPermissionInputBean inputBean) {
        return this.toResponse(() -> (Response)this.filterWithId(filterId, new Filter.Expand[0]).path("permission").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)inputBean), Response.class), new GenericType<List<Filter.FilterPermission>>(){});
    }

    private Invocation.Builder filterResourceForPut(String filterId, Filter.Expand ... expand) {
        return this.addExpands(this.filterTarget().path(filterId), expand).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
    }

    private Invocation.Builder filterResourceForPost(Filter.Expand ... expand) {
        return this.addExpands(this.filterTarget(), expand).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
    }

    public Map<String, String> getDefaultShareScope() {
        return (Map)this.createResource().path("filter").path("defaultShareScope").request().get((GenericType)new GenericType<Map<String, String>>(){});
    }

    public Map<String, String> setDefaultShareScope(Map<String, String> scope) {
        return (Map)this.createResource().path("filter").path("defaultShareScope").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json(scope), (GenericType)new GenericType<Map<String, String>>(){});
    }

    public static class FilterPermissionInputBean {
        public String type;
        public String projectId;
        public String projectRoleId;
        public String groupname;
        public String userKey;
        public boolean view;
        public boolean edit;

        public FilterPermissionInputBean(String type, String projectId, String projectRoleId, String groupname) {
            this.type = type;
            this.projectId = projectId;
            this.projectRoleId = projectRoleId;
            this.groupname = groupname;
        }

        public FilterPermissionInputBean(String type, String projectId, String projectRoleId, String groupname, String userKey, boolean view, boolean edit) {
            this(type, projectId, projectRoleId, groupname);
            this.userKey = userKey;
            this.view = view;
            this.edit = edit;
        }
    }
}

