/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.PageBean;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import java.net.URI;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;

public final class GenericRestClient
extends RestApiClient<GenericRestClient> {
    public GenericRestClient() {
        super(null);
    }

    public <T> ParsedResponse<T> get(URI path, Class<T> responseClass) {
        return this.toResponse(() -> this.getResource(path), responseClass);
    }

    public <T> ParsedResponse<T> get(URI path, GenericType<T> responseType) {
        return this.toResponse(() -> this.getResource(path), responseType);
    }

    public <T> ParsedResponse<PageBean<T>> getNextPage(PageBean<T> currentPage, GenericType<PageBean<T>> actualPageType) {
        if (Boolean.TRUE.equals(currentPage.getIsLast()) || currentPage.getNextPage() == null) {
            throw new IllegalArgumentException("last page or next URL not specified");
        }
        return this.get(currentPage.getNextPage(), actualPageType);
    }

    private Response getResource(URI path) {
        return (Response)this.client().target(path).queryParam("os_authType", new Object[]{"basic"}).queryParam("os_username", new Object[]{GenericRestClient.percentEncode(this.loginAs)}).queryParam("os_password", new Object[]{GenericRestClient.percentEncode(this.loginPassword)}).request().get(Response.class);
    }
}

