/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.StringUtils;
import org.glassfish.jersey.internal.util.collection.MultivaluedStringMap;

public class ICalendarResourceClient
extends RestApiClient<ICalendarResourceClient> {
    public ICalendarResourceClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public ParsedResponse<QueryOptions> getQueryOptions() {
        return this.toResponse(() -> (Response)this.createResource().path("config").path("query").path("options").request().get(Response.class), QueryOptions.class);
    }

    public ParsedResponse validateJql(String jql) {
        MultivaluedStringMap body = new MultivaluedStringMap();
        body.put((Object)"jql", Collections.singletonList(jql));
        return this.toResponse(() -> this.lambda$validateJql$1((MultivaluedMap)body));
    }

    public ParsedResponse<? extends Set> getConfigFields(String jql) {
        return this.toResponse(() -> (Response)this.createResource().path("config").path("fields").queryParam("jql", new Object[]{jql}).request().get(Response.class), HashSet.class);
    }

    public ParsedResponse<? extends Set> getConfigFields(String jql, Boolean useExpandedFieldRetrieval) {
        return this.toResponse(() -> (Response)this.createResource().path("config").path("fields").queryParam("jql", new Object[]{jql}).queryParam("useExpandedFieldRetrieval", new Object[]{String.valueOf(useExpandedFieldRetrieval)}).request().get(Response.class), HashSet.class);
    }

    public ParsedResponse searchWithJql(String jql, String ... dateFieldNames) {
        WebTarget part = this.createResource().path("search").path("jql").path("events.ics").queryParam("jql", new Object[]{jql});
        WebTarget resource = this.applyDateFieldNameQueryParams(part, dateFieldNames);
        return this.toResponse(() -> (Response)resource.request().get(Response.class));
    }

    public ParsedResponse searchWithFilter(String filterId, String ... dateFieldNames) {
        WebTarget part = this.createResource().path("search").path("filter").path("events.ics").queryParam("searchFilterId", new Object[]{filterId});
        WebTarget resource = this.applyDateFieldNameQueryParams(part, dateFieldNames);
        return this.toResponse(() -> (Response)resource.request().get(Response.class));
    }

    @Override
    protected WebTarget createResource() {
        return this.resourceRoot(this.getEnvironmentData().getBaseUrl().toExternalForm()).path("rest").path("ical").path("1.0").path("ical");
    }

    private WebTarget applyDateFieldNameQueryParams(WebTarget part, String[] dateFieldNames) {
        if (dateFieldNames != null) {
            for (String name : dateFieldNames) {
                part = part.queryParam("dateFieldName", new Object[]{name});
            }
        }
        return part;
    }

    private /* synthetic */ Response lambda$validateJql$1(MultivaluedMap body) {
        return this.createResource().path("util").path("jql").path("validate").request().post(Entity.form((MultivaluedMap)body));
    }

    @XmlRootElement
    public static class SearchFilter
    implements Comparable<SearchFilter> {
        @XmlElement
        public long id;
        @XmlElement
        public String name;
        @XmlElement
        public String description;

        @Override
        public int compareTo(SearchFilter searchFilter) {
            int result = StringUtils.defaultString((String)this.name).compareTo(StringUtils.defaultString((String)searchFilter.name));
            return 0 == result ? (int)(this.id - searchFilter.id) : result;
        }
    }

    @XmlRootElement
    public static class SimpleProject
    implements Comparable<SimpleProject> {
        @XmlElement
        public String key;
        @XmlElement
        public String name;

        @Override
        public int compareTo(SimpleProject simpleProject) {
            int result = StringUtils.defaultString((String)this.name).compareTo(StringUtils.defaultString((String)simpleProject.name));
            return 0 == result ? this.key.compareTo(simpleProject.key) : result;
        }
    }

    @XmlRootElement
    public static class QueryOptions {
        @XmlElement
        public List<SimpleProject> projects;
        @XmlElement
        public List<SearchFilter> searchFilters;
        @XmlElement
        public String visibleFieldNames;
        @XmlElement
        public String visibleFunctionNamesJson;
        @XmlElement
        public String jqlReservedWordsJson;
        @XmlElement
        public boolean dateRangeSupported = true;
    }
}

