/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.rest.api.issue.IssueUpdateRequest;
import com.atlassian.jira.rest.api.issue.RemoteIssueLinkCreateOrUpdateRequest;
import com.atlassian.jira.rest.api.issue.RemoteIssueLinkCreateOrUpdateResponse;
import com.atlassian.jira.rest.api.util.StringList;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.Attachment;
import com.atlassian.jira.testkit.client.restclient.FieldMetaData;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueCreateMeta;
import com.atlassian.jira.testkit.client.restclient.IssueType;
import com.atlassian.jira.testkit.client.restclient.OperationalUpdateRequest;
import com.atlassian.jira.testkit.client.restclient.PageBean;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.RemoteIssueLink;
import com.atlassian.jira.testkit.client.restclient.User;
import com.atlassian.jira.util.collect.MapBuilder;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.MultiPart;
import org.glassfish.jersey.media.multipart.file.FileDataBodyPart;

public class IssueClient
extends RestApiClient<IssueClient> {
    public IssueClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public Issue get(String issueKey, Issue.Expand ... expand) throws WebApplicationException {
        return this.get(issueKey, false, expand);
    }

    public Issue get(String issueKey, boolean updateHistory, Issue.Expand ... expand) throws WebApplicationException {
        return (Issue)this.issueResource(issueKey, updateHistory, expand).request().get(Issue.class);
    }

    public Issue getWithProperties(String issueKey, List<String> properties, Issue.Expand ... expand) {
        return (Issue)this.issueResource(issueKey, false, expand).queryParam("properties", new Object[]{String.join((CharSequence)",", properties)}).request().get(Issue.class);
    }

    public WebTarget issueResource(String issueKey, Issue.Expand ... expand) {
        return this.issueWithKey(issueKey, Collections.emptyList(), IssueClient.setOf(Issue.Expand.class, (Enum[])expand), null);
    }

    public WebTarget issueResource(String issueKey, boolean updateHistory, Issue.Expand ... expand) {
        return this.issueWithKey(issueKey, Collections.emptyList(), IssueClient.setOf(Issue.Expand.class, (Enum[])expand), updateHistory);
    }

    public Issue getPartially(String issueKey, StringList ... fields) throws WebApplicationException {
        return this.getPartially(issueKey, IssueClient.setOf(Issue.Expand.class, (Enum[])new Issue.Expand[0]), fields);
    }

    public Issue getPartially(String issueKey, EnumSet<Issue.Expand> expand, StringList ... fields) throws WebApplicationException {
        return (Issue)this.issueWithKey(issueKey, Arrays.asList(fields), expand, null).request().get(Issue.class);
    }

    public Issue getFromURL(String issueURL, Issue.Expand ... expand) throws WebApplicationException {
        EnumSet expands = IssueClient.setOf(Issue.Expand.class, (Enum[])expand);
        return (Issue)this.expanded(this.resourceRoot(issueURL), expands).request().get(Issue.class);
    }

    public IssueCreateResponse create(IssueUpdateRequest issue) {
        return this.create(issue, false);
    }

    public IssueCreateResponse create(IssueUpdateRequest issue, boolean updateHistory) {
        try {
            return (IssueCreateResponse)this.createResource().queryParam("updateHistory", new Object[]{Boolean.toString(updateHistory)}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.entity((Object)issue, (String)"application/json"), IssueCreateResponse.class);
        }
        catch (WebApplicationException e) {
            throw new RuntimeException("Failed to create issue: " + this.errorResponse(e.getResponse()), e);
        }
    }

    public void edit(String issueKey, IssueUpdateRequest updateRequest) {
        try {
            this.createResourceWithIssueKey(issueKey).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)updateRequest));
        }
        catch (WebApplicationException e) {
            throw new RuntimeException("Failed to edit issue: " + this.errorResponse(e.getResponse()), e);
        }
    }

    public ParsedResponse getResponse(IssueUpdateRequest issue) {
        return this.toResponse(() -> (Response)this.createResource().request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)issue), Response.class));
    }

    public ParsedResponse operationalUpdateResponse(String issueKey, OperationalUpdateRequest update) {
        return this.toResponse(() -> (Response)this.createResource().path(issueKey).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)update), Response.class));
    }

    public void operationalUpdate(String issueKey, OperationalUpdateRequest updateRequest) {
        try {
            this.createResource().path(issueKey).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)updateRequest));
        }
        catch (WebApplicationException e) {
            throw new RuntimeException("Failed to update issue: " + this.errorResponse(e.getResponse()), e);
        }
    }

    public void update(String issueKey, IssueUpdateRequest issue) {
        try {
            this.createResource().path(issueKey).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)issue), String.class);
        }
        catch (WebApplicationException e) {
            throw new RuntimeException("Failed to update issue: " + this.errorResponse(e.getResponse()), e);
        }
    }

    public ParsedResponse updateResponse(String issueKey, IssueUpdateRequest update) {
        return this.toResponse(() -> (Response)this.createResource().path(issueKey).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)update), Response.class));
    }

    public ParsedResponse updateResponse(String issueKey, IssueUpdateRequest update, boolean notifyUsers) {
        return this.toResponse(() -> (Response)this.createResource().path(issueKey).queryParam("notifyUsers", new Object[]{Boolean.toString(notifyUsers)}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)update), Response.class));
    }

    public ParsedResponse update(String issueKey, Map update) {
        return this.toResponse(() -> (Response)this.createResource().path(issueKey).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)update), Response.class));
    }

    public ParsedResponse delete(String issueKey, String deleteSubtasks) throws WebApplicationException {
        return this.toResponse(() -> {
            WebTarget deleteResource = this.createResource().path(issueKey);
            if (deleteSubtasks != null) {
                deleteResource = deleteResource.queryParam("deleteSubtasks", new Object[]{deleteSubtasks});
            }
            return (Response)deleteResource.request().delete(Response.class);
        });
    }

    public ParsedResponse assign(String issueKey, User assignee) throws WebApplicationException {
        return this.toResponse(() -> {
            WebTarget assignResource = this.createResource().path(issueKey).path("assignee");
            return assignResource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)assignee));
        }, Response.class);
    }

    public ParsedResponse transition(String issueKey, IssueUpdateRequest transition) {
        return this.toResponse(() -> this.createResource().path(issueKey).path("transitions").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)transition)), Response.class);
    }

    public ParsedResponse getResponse(String issueKey) {
        return this.toResponse(() -> (Response)this.issueWithKey(issueKey, null, IssueClient.setOf(Issue.Expand.class, (Enum[])new Issue.Expand[0]), null).request().get(Response.class));
    }

    protected WebTarget issueWithKey(String issueKey, @Nullable List<StringList> fields, EnumSet<Issue.Expand> expand, Boolean updateHistory) {
        WebTarget resource = this.createResource().path(issueKey);
        resource = this.addStringListsToQueryParams(resource, "fields", fields);
        if (updateHistory != null) {
            resource = resource.queryParam("updateHistory", new Object[]{Boolean.toString(updateHistory)});
        }
        return this.expanded(resource, expand);
    }

    @Deprecated
    public IssueCreateMeta getCreateMeta(@Nullable List<StringList> projectIds, @Nullable List<StringList> projectKeys, @Nullable List<StringList> issueTypeIds, @Nullable List<String> issueTypeNames, IssueCreateMeta.Expand ... expand) {
        return (IssueCreateMeta)this.getCreateMetaResource(projectIds, projectKeys, issueTypeIds, issueTypeNames, IssueClient.setOf(IssueCreateMeta.Expand.class, (Enum[])expand)).request().get(IssueCreateMeta.class);
    }

    @Deprecated
    public ParsedResponse getCreateMetaResponse(@Nullable List<StringList> projectIds, @Nullable List<StringList> projectKeys, @Nullable List<StringList> issueTypeIds, @Nullable List<String> issueTypeNames, IssueCreateMeta.Expand ... expand) {
        return this.toResponse(() -> (Response)this.getCreateMetaResource(projectIds, projectKeys, issueTypeIds, issueTypeNames, IssueClient.setOf(IssueCreateMeta.Expand.class, (Enum[])expand)).request().get(Response.class));
    }

    @Deprecated
    private WebTarget getCreateMetaResource(@Nullable List<StringList> projectIds, @Nullable List<StringList> projectKeys, @Nullable List<StringList> issueTypeIds, @Nullable List<String> issueTypeNames, EnumSet<IssueCreateMeta.Expand> expand) {
        WebTarget resource = this.createResource().path("createmeta");
        resource = this.addStringListsToQueryParams(resource, "projectIds", projectIds);
        resource = this.addStringListsToQueryParams(resource, "projectKeys", projectKeys);
        resource = this.addStringListsToQueryParams(resource, "issuetypeIds", issueTypeIds);
        resource = this.addStringsToQueryParams(resource, "issuetypeNames", issueTypeNames);
        resource = this.expanded(resource, expand);
        return resource;
    }

    public PageBean<IssueType> getCreateIssueMetaProjectIssueTypes(@Nonnull String projectIdOrKey, @Nullable Long startAt, @Nullable Integer maxResults) {
        return (PageBean)this.getCreateIssueMetaProjectIssueTypesResource(projectIdOrKey, startAt, maxResults).request().get((GenericType)new GenericType<PageBean<IssueType>>(){});
    }

    public WebTarget getCreateIssueMetaProjectIssueTypesResource(@Nonnull String projectIdOrKey, @Nullable Long startAt, @Nullable Integer maxResults) {
        WebTarget resource = this.createResource().path("createmeta").path(projectIdOrKey).path("issuetypes");
        resource = resource.queryParam("startAt", new Object[]{startAt == null ? null : startAt.toString()});
        resource = resource.queryParam("maxResults", new Object[]{maxResults == null ? null : maxResults.toString()});
        return resource;
    }

    public PageBean<IssueType> getCreateIssueMetaProjectIssueType(@Nonnull String projectIdOrKey, @Nonnull String issueTypeId, @Nullable Long startAt, @Nullable Integer maxResults) {
        return (PageBean)this.getCreateIssueMetaProjectIssueTypeResource(projectIdOrKey, issueTypeId, startAt, maxResults).request().get((GenericType)new GenericType<PageBean<IssueType>>(){});
    }

    public WebTarget getCreateIssueMetaProjectIssueTypeResource(@Nonnull String projectIdOrKey, @Nonnull String issueTypeId, @Nullable Long startAt, @Nullable Integer maxResults) {
        WebTarget resource = this.createResource().path("createmeta").path(projectIdOrKey).path("issuetypes").path(issueTypeId);
        resource = resource.queryParam("startAt", new Object[]{startAt == null ? null : startAt.toString()});
        resource = resource.queryParam("maxResults", new Object[]{maxResults == null ? null : maxResults.toString()});
        return resource;
    }

    public PageBean<FieldMetaData> getCreateIssueMetaFields(@Nonnull String projectIdOrKey, @Nonnull String issueTypeId, @Nullable Long startAt, @Nullable Integer maxResults) {
        return (PageBean)this.getCreateIssueMetaFieldsResource(projectIdOrKey, issueTypeId, startAt, maxResults).request().get((GenericType)new GenericType<PageBean<FieldMetaData>>(){});
    }

    private WebTarget getCreateIssueMetaFieldsResource(@Nonnull String projectIdOrKey, @Nonnull String issueTypeId, @Nullable Long startAt, @Nullable Integer maxResults) {
        return this.getCreateIssueMetaProjectIssueTypesResource(projectIdOrKey, startAt, maxResults).path(issueTypeId);
    }

    public RemoteIssueLinkCreateOrUpdateResponse createOrUpdateRemoteIssueLink(String issueKey, RemoteIssueLinkCreateOrUpdateRequest remoteIssueLink) {
        try {
            return (RemoteIssueLinkCreateOrUpdateResponse)this.createResource().path(issueKey).path("remotelink").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)remoteIssueLink), RemoteIssueLinkCreateOrUpdateResponse.class);
        }
        catch (WebApplicationException e) {
            throw new RuntimeException("Failed to create remote link: " + this.errorResponse(e.getResponse()), e);
        }
    }

    public ParsedResponse createOrUpdateRemoteIssueLinkAndGetResponse(String issueKey, RemoteIssueLinkCreateOrUpdateRequest remoteIssueLink) {
        return this.toResponse(() -> (Response)this.createResource().path(issueKey).path("remotelink").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)remoteIssueLink), Response.class));
    }

    public Response createOrUpdateRemoteIssueLinkAndGetClientResponse(String issueKey, RemoteIssueLinkCreateOrUpdateRequest remoteIssueLink) {
        return (Response)this.createResource().path(issueKey).path("remotelink").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)remoteIssueLink), Response.class);
    }

    public ParsedResponse updateRemoteIssueLink(String issueKey, String linkId, RemoteIssueLinkCreateOrUpdateRequest remoteIssueLink) {
        return this.toResponse(() -> (Response)this.createResource().path(issueKey).path("remotelink").path(linkId).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)remoteIssueLink), Response.class));
    }

    public ParsedResponse deleteRemoteIssueLink(String issueKey, String remoteIssueLinkId) {
        return this.toResponse(() -> (Response)this.createResource().path(issueKey).path("remotelink").path(remoteIssueLinkId).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).delete(Response.class));
    }

    public ParsedResponse deleteRemoteIssueLinkByGlobalId(String issueKey, String globalId) {
        return this.toResponse(() -> (Response)this.createResource().path(issueKey).path("remotelink").queryParam("globalId", new Object[]{globalId}).request().delete(Response.class));
    }

    public RemoteIssueLink getRemoteIssueLink(String issueKey, String remoteIssueLinkId) {
        return (RemoteIssueLink)this.getRemoteIssueLinkResource(issueKey, remoteIssueLinkId, null).request().get(RemoteIssueLink.class);
    }

    public List<RemoteIssueLink> getRemoteIssueLinks(String issueKey) {
        return (List)this.getRemoteIssueLinkResource(issueKey, null, null).request().get(RemoteIssueLink.REMOTE_ISSUE_LINKS_TYPE);
    }

    public RemoteIssueLink getRemoteIssueLinkByGlobalId(String issueKey, String globalId) {
        Map params = MapBuilder.newBuilder().add((Object)"globalId", (Object)globalId).toMap();
        return (RemoteIssueLink)this.getRemoteIssueLinkResource(issueKey, null, params).request().get(RemoteIssueLink.class);
    }

    public ParsedResponse getRemoteIssueLinkResponse(String issueKey, String remoteIssueLinkId) {
        return this.toResponse(() -> (Response)this.getRemoteIssueLinkResource(issueKey, remoteIssueLinkId, null).request().get(Response.class));
    }

    public ParsedResponse getRemoteIssueLinksResponse(String issueKey) {
        return this.getRemoteIssueLinksResponse(issueKey, null);
    }

    public ParsedResponse getRemoteIssueLinksResponse(String issueKey, @Nullable Map<String, String> queryParams) {
        return this.toResponse(() -> (Response)this.getRemoteIssueLinkResource(issueKey, null, queryParams).request().get(Response.class));
    }

    public Response archive(String issueIdOrKey) {
        Response response = (Response)this.createResource().path(issueIdOrKey).path("archive").request().put(null, Response.class);
        response.close();
        return response;
    }

    public Response restore(String issueIdOrKey) {
        Response response = (Response)this.createResource().path(issueIdOrKey).path("restore").request().put(null, Response.class);
        response.close();
        return response;
    }

    public ParsedResponse<List<Attachment>> attachFile(String issueIdOrKey, File file) {
        return this.toResponse(() -> {
            MultiPart multiPartEntity = new MultiPart(MediaType.MULTIPART_FORM_DATA_TYPE).bodyPart((BodyPart)new FileDataBodyPart("file", file, MediaType.APPLICATION_OCTET_STREAM_TYPE));
            Client client = (Client)this.client().register(requestContext -> requestContext.getHeaders().add((Object)"X-Atlassian-Token", (Object)"nocheck"));
            return (Response)this.createResource(client).path(issueIdOrKey).path("attachments").request().post(Entity.entity((Object)multiPartEntity, (MediaType)multiPartEntity.getMediaType()), Response.class);
        }, new GenericType<List<Attachment>>(){});
    }

    private WebTarget getRemoteIssueLinkResource(String issueKey, @Nullable String remoteIssueLinkId, @Nullable Map<String, String> queryParams) {
        WebTarget resource = this.createResource().path(issueKey).path("remotelink");
        if (remoteIssueLinkId != null) {
            resource = resource.path(remoteIssueLinkId);
        }
        if (queryParams != null) {
            for (Map.Entry<String, String> entry : queryParams.entrySet()) {
                resource = resource.queryParam(entry.getKey(), new Object[]{entry.getValue()});
            }
        }
        return resource;
    }

    private WebTarget addStringListsToQueryParams(WebTarget resource, String paramName, Iterable<StringList> stringLists) {
        if (stringLists != null) {
            for (StringList stringList : stringLists) {
                resource = resource.queryParam(paramName, new Object[]{stringList.toQueryParam()});
            }
        }
        return resource;
    }

    private WebTarget addStringsToQueryParams(WebTarget resource, String paramName, Iterable<String> strings) {
        if (strings != null) {
            for (String string : strings) {
                resource = resource.queryParam(paramName, new Object[]{string});
            }
        }
        return resource;
    }

    private WebTarget createResourceWithIssueKey(String issueKey) {
        return this.createResource().path(issueKey);
    }

    @Override
    protected WebTarget createResource() {
        return super.createResource().path("issue");
    }

    @Override
    protected WebTarget createResource(Client client) {
        return super.createResource(client).path("issue");
    }
}

