/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.IssueLinkType;
import com.atlassian.jira.testkit.client.restclient.IssueLinkTypes;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class IssueLinkTypeClient
extends RestApiClient<IssueLinkTypeClient> {
    public IssueLinkTypeClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public IssueLinkTypeClient(JIRAEnvironmentData environmentData, String version) {
        super(environmentData, version);
    }

    public IssueLinkTypes getIssueLinkTypes() {
        return (IssueLinkTypes)this.issueLinkType().request().get(IssueLinkTypes.class);
    }

    private WebTarget issueLinkType() {
        return this.createResource().path("issueLinkType");
    }

    public IssueLinkType getIssueLinkType(String issueLinkTypeID) {
        return (IssueLinkType)this.issueLinkTypeID(issueLinkTypeID).request().get(IssueLinkType.class);
    }

    public ParsedResponse deleteIssueLinkType(String issueLinkTypeID) {
        return this.toResponse(() -> (Response)this.issueLinkTypeID(issueLinkTypeID).request().delete(Response.class));
    }

    public IssueLinkType createIssueLinkType(String name, String inbound, String outbound) {
        IssueLinkType linkType = new IssueLinkType();
        linkType.inward = inbound;
        linkType.outward = outbound;
        linkType.name = name;
        return (IssueLinkType)this.issueLinkType().request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)linkType), IssueLinkType.class);
    }

    private WebTarget issueLinkTypeID(String issueLinkTypeID) {
        return this.createResource().path("issueLinkType/" + issueLinkTypeID);
    }

    public ParsedResponse getResponseForLinkType(String issueLinkTypeID) {
        return this.toResponse(() -> (Response)this.issueLinkTypeID(issueLinkTypeID).request().get(Response.class));
    }

    public ParsedResponse getResponseForAllLinkTypes() {
        return this.toResponse(() -> (Response)this.issueLinkType().request().get(Response.class));
    }

    public IssueLinkType updateIssueLinkType(String issueLinkTypeID, String name, String inward, String outward) {
        IssueLinkType issueLinkType = new IssueLinkType();
        issueLinkType.name = name;
        issueLinkType.inward = inward;
        issueLinkType.outward = outward;
        return (IssueLinkType)this.createResource().path("issueLinkType/" + issueLinkTypeID).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)issueLinkType), IssueLinkType.class);
    }

    public IssueLinkType moveIssueLinkType(String issueLinkTypeID, long newSequence) {
        String path = String.format("issueLinkType/%s/sequence/%d", issueLinkTypeID, newSequence);
        return (IssueLinkType)this.createResource().path(path).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(null, IssueLinkType.class);
    }
}

