/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.atlassian.jira.testkit.beans.IssueSecuritySchemeBean;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.IssueSecuritySchemes;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;

public class IssueSecuritySchemeClient
extends RestApiClient<IssueSecuritySchemeClient> {
    public IssueSecuritySchemeClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public ParsedResponse<IssueSecuritySchemes> getAllSecuritySchemes() throws WebApplicationException {
        return this.toResponse(() -> (Response)this.resource().request().get(Response.class), IssueSecuritySchemes.class);
    }

    public ParsedResponse<IssueSecuritySchemeBean> get(long schemeId) throws WebApplicationException {
        return this.toResponse(() -> (Response)this.issueSecuritySchemeWithID(schemeId).request().get(Response.class), IssueSecuritySchemeBean.class);
    }

    public ParsedResponse<IssueSecuritySchemeBean> getForProject(String projectIdOrKey) {
        return this.toResponse(() -> (Response)this.createResource().path("project").path(projectIdOrKey).path("issuesecuritylevelscheme").request().get(Response.class), IssueSecuritySchemeBean.class);
    }

    private WebTarget issueSecuritySchemeWithID(long schemeId) {
        return this.resource().path(String.valueOf(schemeId));
    }

    private WebTarget resource() {
        return this.createResource().path("issuesecurityschemes");
    }
}

