/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.IssueType;
import com.atlassian.jira.testkit.client.restclient.IssueTypeCreateBean;
import com.atlassian.jira.testkit.client.restclient.IssueTypeUpdateBean;
import com.atlassian.jira.testkit.client.restclient.PageBean;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import io.atlassian.fugue.Option;
import java.util.List;
import java.util.Set;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class IssueTypeClient
extends RestApiClient<IssueTypeClient> {
    public IssueTypeClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public List<IssueType> get() throws WebApplicationException {
        return (List)this.issueTypes().get((GenericType)new GenericType<List<IssueType>>(){});
    }

    public IssueType get(String issueTypeID) throws WebApplicationException {
        return (IssueType)this.issueTypeWithID(issueTypeID).request().get(IssueType.class);
    }

    public List<IssueType> getAlternatives(String issueTypeId) {
        return (List)this.issueTypeWithID(issueTypeId).path("alternatives").request().get((GenericType)new GenericType<List<IssueType>>(){});
    }

    public IssueType post(IssueTypeCreateBean issueTypeCreateBean) {
        return (IssueType)this.issueTypes().post(Entity.json((Object)issueTypeCreateBean), IssueType.class);
    }

    public IssueType update(String issueTypeId, IssueTypeUpdateBean issueTypeUpdateBean) {
        return (IssueType)this.issueTypeWithID(issueTypeId).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)issueTypeUpdateBean), IssueType.class);
    }

    public ParsedResponse<Object> delete(String issueTypeId, Option<String> alternativeIssueTypeId) {
        WebTarget webTarget = this.issueTypeWithID(issueTypeId);
        return this.toResponse(() -> ((WebTarget)alternativeIssueTypeId.fold(() -> webTarget, alternativeId -> webTarget.queryParam("alternativeIssueTypeId", new Object[]{alternativeId}))).request().delete());
    }

    public ParsedResponse<Object> getResponse(String issueTypeID) {
        return this.toResponse(() -> (Response)this.issueTypeWithID(issueTypeID).request().get(Response.class));
    }

    public PageBean<IssueType> getPage(Long startAt, Integer maxResults, String query, Set<String> projectIds) {
        WebTarget webTarget = this.createResource().path("issuetype").path("page").queryParam("startAt", new Object[]{startAt.toString()}).queryParam("maxResults", new Object[]{maxResults.toString()}).queryParam("query", new Object[]{query});
        for (String projectId : projectIds) {
            webTarget = webTarget.queryParam("projectIds", new Object[]{projectId});
        }
        return (PageBean)webTarget.request().get((GenericType)new GenericType<PageBean<IssueType>>(){});
    }

    private Invocation.Builder issueTypes() {
        return this.createResource().path("issuetype").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
    }

    private WebTarget issueTypeWithID(String issueTypeID) {
        return this.createResource().path("issuetype").path(issueTypeID);
    }
}

