/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.atlassian.jira.testkit.beans.PermissionGrantBean;
import com.atlassian.jira.testkit.beans.PermissionSchemeAttributeBean;
import com.atlassian.jira.testkit.beans.PermissionSchemeBean;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Joiner;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

@ParametersAreNonnullByDefault
public final class PermissionSchemeRestClient
extends RestApiClient<PermissionSchemeRestClient> {
    public PermissionSchemeRestClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public ParsedResponse<PermissionSchemeListBean> getSchemes(Expand ... expands) {
        return this.toResponse(() -> (Response)this.expandQuery(this.resource(), expands).request().get(Response.class), new GenericType<PermissionSchemeListBean>(){});
    }

    public ParsedResponse<PermissionSchemeBean> createScheme(PermissionSchemeBean bean, Expand ... expands) {
        return this.toResponse(() -> (Response)this.expandQuery(this.resource(), expands).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)bean), Response.class), PermissionSchemeBean.class);
    }

    public ParsedResponse<PermissionSchemeBean> getScheme(Long id, Expand ... expands) {
        return this.toResponse(() -> (Response)this.expandQuery(this.resource().path(id.toString()), expands).request().get(Response.class), PermissionSchemeBean.class);
    }

    public ParsedResponse<PermissionSchemeBean> updateScheme(Long id, PermissionSchemeBean updateBean, Expand ... expands) {
        return this.toResponse(() -> (Response)this.expandQuery(this.resource().path(id.toString()), expands).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)updateBean), Response.class), PermissionSchemeBean.class);
    }

    public ParsedResponse<?> deleteScheme(Long id) {
        return this.toResponse(() -> (Response)this.resource().path(id.toString()).request().delete(Response.class));
    }

    public ParsedResponse<PermissionGrantListBean> getPermissions(Long schemeId, Expand ... expands) {
        return this.toResponse(() -> (Response)this.expandQuery(this.resource().path(schemeId.toString()).path("permission"), expands).request().get(Response.class), new GenericType<PermissionGrantListBean>(){});
    }

    public ParsedResponse<PermissionGrantBean> createPermission(Long schemeId, PermissionGrantBean bean, Expand ... expands) {
        return this.toResponse(() -> (Response)this.expandQuery(this.resource().path(schemeId.toString()).path("permission"), expands).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)bean), Response.class), PermissionGrantBean.class);
    }

    public ParsedResponse<PermissionGrantBean> getPermission(Long schemeId, Long permissionId, Expand ... expands) {
        return this.toResponse(() -> (Response)this.expandQuery(this.resource().path(schemeId.toString()).path("permission").path(permissionId.toString()), expands).request().get(Response.class), PermissionGrantBean.class);
    }

    public ParsedResponse<?> deletePermission(Long schemeId, Long permissionId) {
        return this.toResponse(() -> (Response)this.resource().path(schemeId.toString()).path("permission").path(permissionId.toString()).request().delete(Response.class));
    }

    public ParsedResponse<PermissionSchemeBean> getAssignedScheme(String projectKeyOrId) {
        return this.toResponse(() -> (Response)this.projectResource(projectKeyOrId).request().get(Response.class), PermissionSchemeBean.class);
    }

    public ParsedResponse<PermissionSchemeBean> assignScheme(String projectKeyOrId, Long schemeId) {
        return this.toResponse(() -> (Response)this.projectResource(projectKeyOrId).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json(Collections.singletonMap("id", schemeId)), Response.class), PermissionSchemeBean.class);
    }

    public ParsedResponse<PermissionSchemeAttributeBean> getAttribute(Long schemeId, String attributeKey) {
        return this.toResponse(() -> (Response)this.resource().path(schemeId.toString()).path("attribute").path(attributeKey).request().get(Response.class), PermissionSchemeAttributeBean.class);
    }

    public ParsedResponse<?> setAttribute(Long schemeId, PermissionSchemeAttributeBean attribute) {
        return this.toResponse(() -> (Response)this.resource().path(schemeId.toString()).path("attribute").path(attribute.getKey()).request().put(Entity.text((Object)attribute.getValue()), Response.class));
    }

    private WebTarget resource() {
        return this.createResource().path("permissionscheme");
    }

    private WebTarget projectResource(String projectKeyOrId) {
        return this.createResource().path("project").path(projectKeyOrId).path("permissionscheme");
    }

    private WebTarget expandQuery(WebTarget resource, Expand[] expands) {
        return expands.length > 0 ? resource.queryParam("expand", new Object[]{Joiner.on((char)',').join((Object[])expands)}) : resource;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class PermissionSchemeListBean {
        @JsonProperty
        public List<PermissionSchemeBean> permissionSchemes;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class PermissionGrantListBean {
        @JsonProperty
        public List<PermissionGrantBean> permissions;
    }

    public static enum Expand {
        permissions,
        user,
        group,
        projectRole,
        field,
        all;

    }
}

