/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.PrioritySchemeBean;
import com.atlassian.jira.testkit.client.restclient.PrioritySchemeGetAllResponseBean;
import com.atlassian.jira.testkit.client.restclient.PrioritySchemeUpdateBean;
import java.util.Collections;
import java.util.Objects;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class PrioritySchemeClient
extends RestApiClient<PrioritySchemeClient> {
    public PrioritySchemeClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public ParsedResponse<PrioritySchemeBean> createWithDefaultMapping(PrioritySchemeUpdateBean bean) {
        return this.toResponse(() -> (Response)this.resource().request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)bean), Response.class), PrioritySchemeBean.class);
    }

    public ParsedResponse<PrioritySchemeBean> updateWithDefaultMapping(PrioritySchemeUpdateBean bean, PrioritySchemeBean.Expand ... expand) {
        return this.toResponse(() -> (Response)this.schemeResource(bean.getId(), expand).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)bean), Response.class), PrioritySchemeBean.class);
    }

    public ParsedResponse delete(long schemeId) {
        return this.toResponse(() -> (Response)this.schemeResource(schemeId, new PrioritySchemeBean.Expand[0]).request().delete(Response.class));
    }

    public ParsedResponse<PrioritySchemeBean> get(long schemeId, PrioritySchemeBean.Expand ... expand) {
        return this.toResponse(() -> (Response)this.schemeResource(schemeId, expand).request().get(Response.class), PrioritySchemeBean.class);
    }

    public ParsedResponse<PrioritySchemeGetAllResponseBean> getAll(Long startAt, Integer maxResults, PrioritySchemeGetAllResponseBean.Expand ... expand) {
        return this.toResponse(() -> {
            WebTarget webTarget = this.expandedResource(expand);
            if (Objects.nonNull(startAt)) {
                webTarget = webTarget.queryParam("startAt", new Object[]{startAt.toString()});
            }
            if (Objects.nonNull(maxResults)) {
                webTarget = webTarget.queryParam("maxResults", new Object[]{maxResults.toString()});
            }
            return (Response)webTarget.request().get(Response.class);
        }, PrioritySchemeGetAllResponseBean.class);
    }

    public ParsedResponse<PrioritySchemeBean> assign(long schemeId, String projectKey, PrioritySchemeBean.Expand ... expand) {
        return this.toResponse(() -> (Response)this.expanded(this.projectSchemeResource(projectKey), PrioritySchemeClient.setOf(PrioritySchemeBean.Expand.class, (Enum[])expand)).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json(Collections.singletonMap("id", schemeId)), Response.class), PrioritySchemeBean.class);
    }

    public ParsedResponse<PrioritySchemeBean> unassign(long schemeId, String projectKey, PrioritySchemeBean.Expand ... expand) {
        return this.toResponse(() -> (Response)this.expanded(this.projectSchemeResource(projectKey).path(Long.toString(schemeId)), PrioritySchemeClient.setOf(PrioritySchemeBean.Expand.class, (Enum[])expand)).request().delete(Response.class), PrioritySchemeBean.class);
    }

    public ParsedResponse<PrioritySchemeBean> getForProject(String projectKey, PrioritySchemeBean.Expand ... expand) {
        return this.toResponse(() -> (Response)this.expanded(this.projectSchemeResource(projectKey), PrioritySchemeClient.setOf(PrioritySchemeBean.Expand.class, (Enum[])expand)).request().get(Response.class), PrioritySchemeBean.class);
    }

    private WebTarget expandedResource(PrioritySchemeBean.Expand ... expand) {
        return this.expanded(this.resource(), PrioritySchemeClient.setOf(PrioritySchemeBean.Expand.class, (Enum[])expand));
    }

    private WebTarget expandedResource(PrioritySchemeGetAllResponseBean.Expand ... expand) {
        return this.expanded(this.resource(), PrioritySchemeClient.setOf(PrioritySchemeGetAllResponseBean.Expand.class, (Enum[])expand));
    }

    private WebTarget resource() {
        return this.createResource().path("priorityschemes");
    }

    private WebTarget schemeResource(long schemeId, PrioritySchemeBean.Expand ... expand) {
        return this.expanded(this.resource().path(Long.toString(schemeId)), PrioritySchemeClient.setOf(PrioritySchemeBean.Expand.class, (Enum[])expand));
    }

    private WebTarget projectSchemeResource(String projectKey) {
        return this.createResource().path("project").path(projectKey).path("priorityscheme");
    }
}

