/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.Avatar;
import com.atlassian.jira.testkit.client.restclient.Component;
import com.atlassian.jira.testkit.client.restclient.PageBean;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.Project;
import com.atlassian.jira.testkit.client.restclient.ProjectUpdateField;
import com.atlassian.jira.testkit.client.restclient.Version;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class ProjectClient
extends RestApiClient<ProjectClient> {
    public ProjectClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public Project get(String projectKey) throws WebApplicationException {
        return (Project)this.projectWithKey(projectKey).request().get(Project.class);
    }

    public Project getAndExpandAll(String projectKey) throws WebApplicationException {
        return (Project)this.projectWithKey(projectKey).queryParam("expand", new Object[]{"description,lead,url,projectKeys"}).request().get(Project.class);
    }

    public Response create(Object project) {
        return this.registerResponse((Response)this.projects().request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)project), Response.class));
    }

    public Response update(String keyOrId, UpdateBean newData) {
        return this.registerResponse((Response)this.projectWithKey(keyOrId).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)newData.json), Response.class));
    }

    public ParsedResponse<Project> updateProjectType(String keyOrId, String newProjectTypeKey) {
        return this.toResponse(() -> (Response)this.projectWithKey(keyOrId).path("type").path(newProjectTypeKey).request().put(null, Response.class), Project.class);
    }

    public Response delete(String keyOrId) {
        return this.registerResponse((Response)this.projectWithKey(keyOrId).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).delete(Response.class));
    }

    public List<Project> getProjects() {
        return (List)this.projects().request().get(Project.PROJECTS_TYPE);
    }

    public List<Project> getProjects(String expand) {
        return (List)this.projects(expand).request().get(Project.PROJECTS_TYPE);
    }

    public Response getRecentProjects(String expand, int count) {
        return (Response)this.projects(expand).queryParam("recent", new Object[]{String.valueOf(count)}).request().get(Response.class);
    }

    public Response getRecentProjects(int count) {
        return this.registerResponse((Response)this.projects().queryParam("recent", new Object[]{String.valueOf(count)}).request().get(Response.class));
    }

    public List<Version> getVersions(String key) {
        return (List)this.projectVersionWithKey(key).request().get(Version.VERSIONS_TYPE);
    }

    public PageBean<Version> getVersionsPaged(String key, Long startAt, Integer maxResults, String orderBy) {
        WebTarget webTarget = this.projectVersionsPaged(key);
        if (startAt != null) {
            webTarget = webTarget.queryParam("startAt", new Object[]{startAt.toString()});
        }
        if (maxResults != null) {
            webTarget = webTarget.queryParam("maxResults", new Object[]{maxResults.toString()});
        }
        if (orderBy != null) {
            webTarget = webTarget.queryParam("orderBy", new Object[]{orderBy});
        }
        return (PageBean)webTarget.request().get(Version.VERSIONS_PAGED_TYPE);
    }

    public Map<String, List<Avatar>> getAvatars(String key) {
        return (Map)this.projectWithKey(key).path("avatars").request().get(Avatar.ALLAVATARS_TYPE);
    }

    public Avatar getAvatar(String key, Long id) {
        return (Avatar)this.projectWithKey(key).path("avatar").path(id.toString()).request().get(Avatar.AVATAR_TYPE);
    }

    public ParsedResponse getResponse(String projectKey) {
        return this.toResponse(() -> (Response)this.projectWithKey(projectKey).request().get(Response.class));
    }

    public ParsedResponse getVersionsResponse(String projectKey) {
        return this.toResponse(() -> (Response)this.projectWithKey(projectKey).request().get(Response.class));
    }

    public List<Component> getComponents(String key) {
        return (List)this.projectComponentWithKey(key).request().get(Component.COMPONENTS_TYPE);
    }

    public Response archive(String projectIdOrKey) {
        Response response = (Response)this.projects().path(projectIdOrKey).path("archive").request().put(null, Response.class);
        response.close();
        return response;
    }

    public Response restore(String projectIdOrKey) {
        Response response = (Response)this.projects().path(projectIdOrKey).path("restore").request().put(null, Response.class);
        response.close();
        return response;
    }

    protected WebTarget projectWithKey(String projectKey) {
        return this.projects().path(projectKey);
    }

    protected WebTarget projectVersionWithKey(String projectKey) {
        return this.projectWithKey(projectKey).path("versions");
    }

    protected WebTarget projectVersionsPaged(String projectKey) {
        return this.projectWithKey(projectKey).path("version");
    }

    protected WebTarget projectComponentWithKey(String projectKey) {
        return this.projectWithKey(projectKey).path("components");
    }

    protected WebTarget projects() {
        return this.createResource().path("project");
    }

    protected WebTarget projects(String expand) {
        return this.projects().queryParam("expand", new Object[]{expand});
    }

    public static class UpdateBean {
        private final Map<String, String> json;

        private UpdateBean(Map<ProjectUpdateField, String> fieldsToUpdate) {
            ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
            for (ProjectUpdateField field : fieldsToUpdate.keySet()) {
                mapBuilder.put((Object)field.jsonFieldName(), (Object)fieldsToUpdate.get((Object)field));
            }
            this.json = mapBuilder.build();
        }

        public Map<String, String> getJson() {
            return Maps.newHashMap(this.json);
        }

        public static UpdateBeanBuilder builder() {
            return new UpdateBeanBuilder(Collections.emptyMap());
        }

        public static class UpdateBeanBuilder {
            private final Map<ProjectUpdateField, String> builder;

            public UpdateBeanBuilder(Map<ProjectUpdateField, String> builder) {
                this.builder = builder;
            }

            public UpdateBeanBuilder with(ProjectUpdateField field, Object value) {
                ImmutableMap newMap = ImmutableMap.builder().putAll(this.builder).put((Object)field, (Object)value.toString()).build();
                return new UpdateBeanBuilder((Map<ProjectUpdateField, String>)newMap);
            }

            public UpdateBean build() {
                return new UpdateBean(this.builder);
            }
        }
    }
}

