/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.ProjectRole;
import com.atlassian.jira.testkit.client.restclient.ProjectRoleActorsUpdate;
import com.atlassian.jira.testkit.client.restclient.ProjectRoleClient2;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class ProjectRoleClient
extends RestApiClient<ProjectRoleClient> {
    protected final ProjectRoleClient2 projectRoleClient2;
    public GenericType<Map<String, String>> TYPE = new GenericType(HashMap.class);

    public ProjectRoleClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
        this.projectRoleClient2 = new ProjectRoleClient2(environmentData);
    }

    public Map<String, String> get(String projectKey) throws WebApplicationException {
        return (Map)this.rolesWithProjectKey(projectKey).request().get(this.TYPE);
    }

    public void deleteRole(String name) {
        this.projectRoleClient2.deleteRole(name);
    }

    public long addRole(String name, String description) {
        return this.projectRoleClient2.addRole(name, description);
    }

    public long addRole(String name) {
        return this.projectRoleClient2.addRole(name, "");
    }

    public ProjectRole get(String projectKey, String role) {
        WebTarget webTarget = this.resourceRoot(this.get(projectKey).get(role));
        return (ProjectRole)webTarget.request().get(ProjectRole.class);
    }

    public ParsedResponse addActors(String projectKey, String role, @Nullable String[] groupNames, @Nullable String[] userNames) {
        ProjectRole projectRole = this.get(projectKey, role);
        return this.toResponse(() -> {
            WebTarget webTarget = this.rolesWithProjectKey(projectKey).path(projectRole.id.toString());
            HashMap parameter = Maps.newHashMap();
            if (groupNames != null) {
                parameter.put("group", groupNames);
            }
            if (userNames != null) {
                parameter.put("user", userNames);
            }
            return (Response)webTarget.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)parameter), Response.class);
        });
    }

    public ParsedResponse deleteGroup(String projectKey, String role, String groupName) {
        ProjectRole projectRole = this.get(projectKey, role);
        return this.toResponse(() -> {
            WebTarget webTarget = this.rolesWithProjectKey(projectKey).path(projectRole.id.toString()).queryParam("group", new Object[]{groupName});
            return (Response)webTarget.request().delete(Response.class);
        });
    }

    public ParsedResponse deleteUser(String projectKey, String role, String userName) {
        ProjectRole projectRole = this.get(projectKey, role);
        return this.toResponse(() -> {
            WebTarget webTarget = this.rolesWithProjectKey(projectKey).path(projectRole.id.toString()).queryParam("user", new Object[]{userName});
            return (Response)webTarget.request().delete(Response.class);
        });
    }

    protected WebTarget rolesWithProjectKey(String projectKey) {
        return this.createResource().path("project").path(projectKey).path("role");
    }

    public ParsedResponse setActors(String projectKey, String role, Map<String, String[]> actors) {
        ProjectRole projectRole = this.get(projectKey, role);
        return this.toResponse(() -> {
            WebTarget webTarget = this.rolesWithProjectKey(projectKey).path(projectRole.id.toString());
            ProjectRoleActorsUpdate projectRoleActorsUpdate = new ProjectRoleActorsUpdate(projectRole.id, actors);
            return (Response)webTarget.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)projectRoleActorsUpdate), Response.class);
        });
    }
}

