/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.atlassian.jira.testkit.beans.ProjectTypeBean;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import java.util.List;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;

public class ProjectTypeClient
extends RestApiClient<ProjectTypeClient> {
    public ProjectTypeClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public ParsedResponse<List<ProjectTypeBean>> getAllProjectTypes() {
        return this.toResponse(() -> (Response)this.projectTypes().request().get(Response.class), new GenericType<List<ProjectTypeBean>>(){});
    }

    public ParsedResponse<ProjectTypeBean> getByKey(String projectTypeKey) {
        return this.toResponse(() -> (Response)this.projectTypes().path(projectTypeKey).request().get(Response.class), ProjectTypeBean.class);
    }

    public ParsedResponse<ProjectTypeBean> getAccessibleProjectTypeByKey(String projectTypeKey) {
        return this.toResponse(() -> (Response)this.projectTypes().path(projectTypeKey).path("accessible").request().get(Response.class), ProjectTypeBean.class);
    }

    protected WebTarget projectTypes() {
        return this.createResource().path("project/type");
    }
}

