/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.ProjectRole;
import com.atlassian.jira.testkit.client.restclient.ProjectRoleActorsBean;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;

public class RoleClient
extends RestApiClient<RoleClient> {
    public RoleClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public ProjectRole get(String roleKey) {
        return (ProjectRole)this.roles().path(roleKey).request().get(ProjectRole.class);
    }

    public List<ProjectRole> get() {
        return (List)this.roles().request().get((GenericType)new GenericType<List<ProjectRole>>(){});
    }

    public ProjectRole create(String name, String description) {
        return (ProjectRole)this.roles().request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)new CreateProjectRoleBean(name, description)), ProjectRole.class);
    }

    public ProjectRole updatePartial(Long id, String name, String description) {
        return (ProjectRole)this.roles().path(String.valueOf(id)).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)new CreateProjectRoleBean(name, description)), ProjectRole.class);
    }

    public ProjectRole updateFull(Long id, String name, String description) {
        return (ProjectRole)this.roles().path(String.valueOf(id)).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)new CreateProjectRoleBean(name, description)), ProjectRole.class);
    }

    public void deleteProjectRole(Long id) {
        this.roles().path(String.valueOf(id)).request().delete(String.class);
    }

    public void deleteProjectRole(Long id, Long replacementId) {
        this.roles().path(String.valueOf(id)).queryParam("swap", new Object[]{String.valueOf(replacementId)}).request().delete(String.class);
    }

    public ProjectRoleActorsBean getDefaultActorsForRole(Long id) {
        return (ProjectRoleActorsBean)this.roles().path(String.valueOf(id)).path("actors").request().get(ProjectRoleActorsBean.class);
    }

    public ProjectRoleActorsBean addDefaultActorsToRole(Long id, String[] usernames, String[] groupnames) {
        return (ProjectRoleActorsBean)this.roles().path(String.valueOf(id)).path("actors").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)new ActorInputBean(usernames == null ? null : Arrays.asList(usernames), groupnames == null ? null : Arrays.asList(groupnames))), ProjectRoleActorsBean.class);
    }

    public ProjectRoleActorsBean deleteDefaultActorsToRole(Long id, String username, String groupname) {
        WebTarget actors = this.roles().path(String.valueOf(id)).path("actors");
        if (username != null) {
            actors = actors.queryParam("user", new Object[]{username});
        }
        if (groupname != null) {
            actors = actors.queryParam("group", new Object[]{groupname});
        }
        return (ProjectRoleActorsBean)actors.request().delete(ProjectRoleActorsBean.class);
    }

    protected WebTarget roles() {
        return this.createResource().path("role");
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class ActorInputBean {
        @JsonProperty
        private Collection<String> user;
        @JsonProperty
        private Collection<String> group;

        @JsonCreator
        public ActorInputBean(@JsonProperty(value="user") Collection<String> usernames, @JsonProperty(value="group") Collection<String> groupnames) {
            this.user = usernames;
            this.group = groupnames;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class CreateProjectRoleBean {
        @JsonProperty
        private String name;
        @JsonProperty
        private String description;

        public CreateProjectRoleBean(String name, String description) {
            this.name = name;
            this.description = description;
        }
    }
}

