/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.AddField;
import com.atlassian.jira.testkit.client.restclient.MoveField;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.Screen;
import com.atlassian.jira.testkit.client.restclient.ScreenField;
import com.atlassian.jira.testkit.client.restclient.ScreenTab;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class ScreensClient
extends RestApiClient<ScreensClient> {
    private final Long id;

    public ScreensClient(JIRAEnvironmentData environmentData, Long id) {
        super(environmentData);
        this.id = id;
    }

    public List<ScreenTab> getAllTabs() {
        return this.getAllTabs(null);
    }

    public List<ScreenTab> getAllTabs(String projectKey) {
        return (List)this.getTabsResource(projectKey).request().get(ScreenTab.LIST);
    }

    public ParsedResponse getAllTabsResponse() {
        return this.getAllTabsResponse(null);
    }

    public ParsedResponse getAllTabsResponse(String projectKey) {
        return this.toResponse(() -> (Response)this.getTabsResource(projectKey).request().get(Response.class));
    }

    public ScreenTab createTab(String name) {
        ScreenTab screenTab = new ScreenTab();
        screenTab.name = name;
        return (ScreenTab)this.getTabsResource().request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)screenTab), ScreenTab.class);
    }

    public ParsedResponse createTabWithResponse(String name) {
        ScreenTab screenTab = new ScreenTab();
        screenTab.name = name;
        return this.toResponse(() -> (Response)this.getTabsResource().request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)screenTab), Response.class));
    }

    public void deleteTab(Long id) {
        this.getTabsResource().path("" + id).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).delete();
    }

    public ParsedResponse deleteTabWithResponse(Long id) {
        return this.toResponse(() -> (Response)this.getTabsResource().path("" + id).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).delete(Response.class));
    }

    public ScreenTab renameTab(Long id, String name) {
        ScreenTab screenTab = new ScreenTab();
        screenTab.name = name;
        return (ScreenTab)this.getTabsResource().path("" + id).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)screenTab), ScreenTab.class);
    }

    public ParsedResponse renameTabWithResponse(Long id, String name) {
        return this.toResponse(() -> {
            ScreenTab screenTab = new ScreenTab();
            screenTab.name = name;
            return (Response)this.getTabsResource().path("" + id).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)screenTab), Response.class);
        });
    }

    public void moveTab(Long id, Integer pos) {
        this.getTabsResource().path("" + id).path("move").path("" + pos).request().post(null);
    }

    public ParsedResponse moveTabWithResponse(Long id, Integer pos) {
        return this.toResponse(() -> (Response)this.getTabsResource().path("" + id).path("move").path("" + pos).request().post(null, Response.class));
    }

    public ScreenField addField(Long tab, String field) {
        AddField screenField = new AddField();
        screenField.fieldId = field;
        return (ScreenField)this.getTabsResource().path("" + tab).path("fields").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)screenField), ScreenField.class);
    }

    public ParsedResponse addFieldWithResponse(Long tab, String field) {
        return this.toResponse(() -> {
            AddField screenField = new AddField();
            screenField.fieldId = field;
            return (Response)this.getTabsResource().path("" + tab).path("fields").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)screenField), Response.class);
        });
    }

    public void moveField(Long tab, String fieldId, MoveField moveField) {
        this.getTabsResource().path("" + tab).path("fields").path(fieldId).path("move").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)moveField));
    }

    public ParsedResponse moveFieldWithResponse(Long tab, String fieldId, MoveField moveField) {
        return this.toResponse(() -> (Response)this.getTabsResource().path("" + tab).path("fields").path(fieldId).path("move").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)moveField), Response.class));
    }

    public void removeField(Long tab, String field) {
        this.getTabsResource().path("" + tab).path("fields").path(field).request().delete();
    }

    public ParsedResponse removeFieldWithResponse(Long tab, String field) {
        return this.toResponse(() -> (Response)this.getTabsResource().path("" + tab).path("fields").path(field).request().delete(Response.class));
    }

    public List<ScreenField> getAvailableFields() {
        return (List)this.screen().path("availableFields").request().get(ScreenField.LIST);
    }

    public ParsedResponse getFieldsResponse(Long tab) {
        return this.getFieldsResponse(tab, null);
    }

    public ParsedResponse getFieldsResponse(Long tab, String projectKey) {
        return this.toResponse(() -> (Response)this.getTabsResource(projectKey).path("" + tab).path("fields").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(Response.class));
    }

    public List<ScreenField> getFields(Long tab) {
        return this.getFields(tab, null);
    }

    public List<ScreenField> getFields(Long tab, String projectKey) {
        return (List)this.getTabsResource(projectKey).path("" + tab).path("fields").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(ScreenField.LIST);
    }

    public ParsedResponse getAllScreensResponse() {
        return this.toResponse(() -> (Response)this.createResource().path("screens").request().get(Response.class));
    }

    public List<Screen> getAllScreens() {
        return (List)this.createResource().path("screens").request().get(Screen.LIST);
    }

    protected WebTarget screen() {
        return this.createResource().path("screens").path("" + this.id);
    }

    private WebTarget getTabsResource() {
        return this.getTabsResource(null);
    }

    private WebTarget getTabsResource(String projectKey) {
        WebTarget screenWebTarget = this.screen();
        if (projectKey != null) {
            screenWebTarget = screenWebTarget.queryParam("projectKey", new Object[]{projectKey});
        }
        return screenWebTarget.path("tabs");
    }
}

