/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.atlassian.jira.rest.api.util.StringList;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.SearchRequest;
import com.atlassian.jira.testkit.client.restclient.SearchResult;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class SearchClient
extends RestApiClient<SearchClient> {
    public SearchClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public SearchResult getSearch(SearchRequest searchRequest) {
        return (SearchResult)this.searchResourceForGet(searchRequest).request().get(SearchResult.class);
    }

    public ParsedResponse getSearchResponse(SearchRequest searchRequest) {
        return this.toResponse(() -> (Response)this.searchResourceForGet(searchRequest).request().get(Response.class));
    }

    public SearchResult postSearch(SearchRequest searchRequest) {
        return (SearchResult)this.searchResourceForPost().post(Entity.json((Object)searchRequest), SearchResult.class);
    }

    public ParsedResponse<SearchResult> postSearchResponse(SearchRequest searchRequest) {
        return this.toResponse(() -> (Response)this.searchResourceForPost().post(Entity.json((Object)searchRequest), Response.class), SearchResult.class);
    }

    private WebTarget searchResource() {
        return this.createResource().path("search");
    }

    private Invocation.Builder searchResourceForPost() {
        return this.searchResource().request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
    }

    private WebTarget searchResourceForGet(SearchRequest searchRequest) {
        WebTarget resource = this.searchResource();
        if (searchRequest.jql != null) {
            resource = resource.queryParam("jql", new Object[]{searchRequest.jql});
        }
        if (searchRequest.startAt != null) {
            resource = resource.queryParam("startAt", new Object[]{searchRequest.startAt.toString()});
        }
        if (searchRequest.maxResults != null) {
            resource = resource.queryParam("maxResults", new Object[]{searchRequest.maxResults.toString()});
        }
        if (searchRequest.validateQuery != null) {
            resource = resource.queryParam("validateQuery", new Object[]{searchRequest.validateQuery.toString()});
        }
        if (searchRequest.fields != null) {
            resource = resource.queryParam("fields", new Object[]{StringList.fromList(searchRequest.fields).toQueryParam()});
        }
        if (searchRequest.expand != null) {
            resource = resource.queryParam("expand", new Object[]{StringList.fromList(searchRequest.expand).toQueryParam()});
        }
        return resource;
    }
}

