/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.User;
import com.atlassian.jira.testkit.client.restclient.UserBean;
import com.atlassian.jira.testkit.client.restclient.UserPickerResults;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

public class UserClient
extends RestApiClient<UserClient> {
    public UserClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public User get(String username, User.Expand ... expand) {
        return this.get(username, false, expand);
    }

    public User get(String username, boolean includeDeleted, User.Expand ... expand) {
        return (User)this.userWithUsername(username, includeDeleted, UserClient.setOf(User.Expand.class, (Enum[])expand)).request().get(User.class);
    }

    public User getByKey(String key, User.Expand ... expand) {
        return this.getByKey(key, false, expand);
    }

    public User getByKey(String key, boolean includeDeleted, User.Expand ... expand) {
        return (User)this.userWithKey(key, includeDeleted, UserClient.setOf(User.Expand.class, (Enum[])expand)).request().get(User.class);
    }

    public List<User> searchAssignable(String query, String issueKey, String startAt, String maxResults) {
        WebTarget resource = this.getSearchAssignableResource(query, issueKey, startAt, maxResults);
        return Arrays.asList((Object[])resource.request().get(User[].class));
    }

    public List<User> multiProjectSearchAssignable(String query, String projectKeys, String startAt, String maxResults) {
        WebTarget resource = this.getMultiProjectSearchAssignableResource(query, projectKeys, startAt, maxResults);
        return Arrays.asList((Object[])resource.request().get(User[].class));
    }

    public List<User> searchViewableIssue(String query, String issueKey, String startAt, String maxResults) {
        WebTarget resource = this.getSearchViewableIssueResource(query, issueKey, startAt, maxResults);
        return Arrays.asList((Object[])resource.request().get(User[].class));
    }

    public List<User> search(String query, String startAt, String maxResults) {
        WebTarget resource = this.getSearchResource(query, startAt, maxResults, null, null);
        return Arrays.asList((Object[])resource.request().get(User[].class));
    }

    public List<User> search(String query, String startAt, String maxResults, Boolean includeActive, Boolean includeInactive) {
        WebTarget resource = this.getSearchResource(query, startAt, maxResults, includeActive, includeInactive);
        return Arrays.asList((Object[])resource.request().get(User[].class));
    }

    public UserPickerResults picker(String query, String maxResults) {
        WebTarget resource = this.getPickerResource(query, maxResults);
        return (UserPickerResults)resource.request().get(UserPickerResults.class);
    }

    public UserBean createUser(UserBean userBean) {
        return (UserBean)this.createResource().path("user").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)userBean), UserBean.class);
    }

    public UserBean updateEmail(String userName, String newEmail) {
        return this.updateUser(userName, UserBean.builder().setEmailAddress(newEmail).build());
    }

    public UserBean updateDisplayName(String userName, String displayName) {
        return this.updateUser(userName, UserBean.builder().setDisplayName(displayName).build());
    }

    public UserBean updatePassword(String userName, String password) {
        return this.updateUser(userName, UserBean.builder().setPassword(password).build());
    }

    public UserBean updateName(String userName, String newName) {
        return this.updateUser(userName, UserBean.builder().setName(newName).build());
    }

    public UserBean updateUser(String userName, UserBean updateBean) {
        return (UserBean)this.createResource().path("user").queryParam("username", new Object[]{userName}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)updateBean), UserBean.class);
    }

    public void addUserToApplication(String userName, String applicationKey) {
        this.applicationAccessResource(userName, applicationKey).request().post(null);
    }

    public List<User> searchByPermission(String query, String permissions, String issueKey, String projectKey, String startAt, String maxResults) {
        WebTarget resource = this.getSearchByPermissionResource(query, permissions, issueKey, projectKey, startAt, maxResults);
        return Arrays.asList((Object[])resource.request().get(User[].class));
    }

    public ParsedResponse searchByPermissionResponse(String query, String permissions, String issueKey, String projectKey, String startAt, String maxResults) {
        WebTarget resource = this.getSearchByPermissionResource(query, permissions, issueKey, projectKey, startAt, maxResults);
        return this.getResponse(resource);
    }

    public ParsedResponse addUserToApplicationResponse(String username, String applicationKey) {
        return this.postResponse(this.applicationAccessResource(username, applicationKey));
    }

    public void removeUserFromApplication(String username, String applicationKey) {
        this.applicationAccessResource(username, applicationKey).request().delete();
    }

    public ParsedResponse removeUserFromApplicationResponse(String username, String applicationKey) {
        return this.deleteResponse(this.applicationAccessResource(username, applicationKey));
    }

    public WebTarget applicationAccessResource(String username, String applicationKey) {
        return this.createResource().path("user").path("application").queryParam("username", new Object[]{username}).queryParam("applicationKey", new Object[]{applicationKey});
    }

    public WebTarget getSearchAssignableResource(String query, String issueKey, String startAt, String maxResults) {
        WebTarget resource = this.applyPagingParams(query, startAt, maxResults, this.createResource().path("user").path("assignable").path("search"));
        resource = resource.queryParam("issueKey", new Object[]{issueKey});
        return resource;
    }

    public WebTarget getMultiProjectSearchAssignableResource(String query, String projectKeys, String startAt, String maxResults) {
        WebTarget resource = this.applyPagingParams(query, startAt, maxResults, this.createResource().path("user").path("assignable").path("multiProjectSearch"));
        resource = resource.queryParam("projectKeys", new Object[]{projectKeys});
        return resource;
    }

    public WebTarget getSearchViewableIssueResource(String query, String issueKey, String startAt, String maxResults) {
        WebTarget resource = this.applyPagingParams(query, startAt, maxResults, this.createResource().path("user").path("viewissue").path("search"));
        resource = resource.queryParam("issueKey", new Object[]{issueKey});
        return resource;
    }

    public WebTarget getSearchResource(String query, String startAt, String maxResults, Boolean includeActive, Boolean includeInactive) {
        WebTarget resource = this.applyPagingParams(query, startAt, maxResults, this.createResource().path("user").path("search"));
        if (includeActive != null) {
            resource = resource.queryParam("includeActive", new Object[]{includeActive.toString()});
        }
        if (includeInactive != null) {
            resource = resource.queryParam("includeInactive", new Object[]{includeInactive.toString()});
        }
        return resource;
    }

    public WebTarget getSearchByPermissionResource(String query, String permissions, String issueKey, String projectKey, String startAt, String maxResults) {
        WebTarget resource = this.createResource().path("user").path("permission").path("search");
        resource = StringUtils.isNotBlank((String)query) ? resource.queryParam("username", new Object[]{query}) : resource;
        resource = StringUtils.isNotBlank((String)issueKey) ? resource.queryParam("issueKey", new Object[]{issueKey}) : resource;
        resource = StringUtils.isNotBlank((String)projectKey) ? resource.queryParam("projectKey", new Object[]{projectKey}) : resource;
        resource = StringUtils.isNotBlank((String)startAt) ? resource.queryParam("startAt", new Object[]{startAt}) : resource;
        resource = StringUtils.isNotBlank((String)maxResults) ? resource.queryParam("maxResults", new Object[]{maxResults}) : resource;
        resource = resource.queryParam("permissions", new Object[]{permissions});
        return resource;
    }

    public WebTarget getPickerResource(String query, String maxResults) {
        WebTarget resource = this.createResource().path("user").path("picker");
        if (StringUtils.isNotBlank((String)query)) {
            resource = resource.queryParam("query", new Object[]{query});
        }
        if (StringUtils.isNotBlank((String)maxResults)) {
            resource = resource.queryParam("maxResults", new Object[]{maxResults});
        }
        return resource;
    }

    private WebTarget applyPagingParams(String query, String startAt, String maxResults, WebTarget resource) {
        resource = resource.queryParam("username", new Object[]{query});
        if (StringUtils.isNotBlank((String)startAt)) {
            resource = resource.queryParam("startAt", new Object[]{startAt});
        }
        if (StringUtils.isNotBlank((String)maxResults)) {
            resource = resource.queryParam("maxResults", new Object[]{maxResults});
        }
        return resource;
    }

    public ParsedResponse getUserResponse(String username) {
        return this.getUserResponse(username, false);
    }

    public ParsedResponse getUserResponse(String username, boolean includeDeleted) {
        return this.getResponse(this.userWithUsername(username, includeDeleted, UserClient.setOf(User.Expand.class, (Enum[])new User.Expand[0])));
    }

    public ParsedResponse getUserResponseByKey(String key) {
        return this.getUserResponseByKey(key, false);
    }

    public ParsedResponse getUserResponseByKey(String key, boolean includeDeleted) {
        return this.getResponse(this.userWithKey(key, includeDeleted, UserClient.setOf(User.Expand.class, (Enum[])new User.Expand[0])));
    }

    public ParsedResponse getResponse(WebTarget resource) {
        return this.toResponse(() -> (Response)resource.request().get(Response.class));
    }

    private ParsedResponse postResponse(WebTarget resource) {
        return this.toResponse(() -> (Response)resource.request().post(null, Response.class));
    }

    private ParsedResponse deleteResponse(WebTarget resource) {
        return this.toResponse(() -> (Response)resource.request().delete(Response.class));
    }

    private WebTarget userWithUsername(String username, boolean includeDeleted, EnumSet<User.Expand> expands) {
        WebTarget result = this.createResource().path("user");
        if (username != null) {
            result = result.queryParam("username", new Object[]{UserClient.percentEncode(username)});
        }
        if (includeDeleted) {
            result = result.queryParam("includeDeleted", new Object[]{"true"});
        }
        return this.expanded(result, expands);
    }

    private WebTarget userWithKey(String key, boolean includeDeleted, EnumSet<User.Expand> expands) {
        WebTarget result = this.createResource().path("user");
        if (key != null) {
            result = result.queryParam("key", new Object[]{UserClient.percentEncode(key)});
        }
        if (includeDeleted) {
            result = result.queryParam("includeDeleted", new Object[]{"true"});
        }
        return this.expanded(result, expands);
    }
}

